/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class MessageResourceBundle {
    static final Object ASSIGNED = new Object();
    private static final String EXTENSION = ".properties";
    private static String[] nlSuffixes;
    static int SEVERITY_ERROR;
    static int SEVERITY_WARNING;

    private static String[] buildVariants(String string) {
        Object object;
        if (nlSuffixes == null) {
            object = Locale.getDefault().toString();
            ArrayList<String> arrayList = new ArrayList<String>(4);
            while (true) {
                arrayList.add('_' + (String)object + EXTENSION);
                int n = object.lastIndexOf(95);
                if (n == -1) break;
                object = object.substring(0, n);
            }
            arrayList.add(EXTENSION);
            nlSuffixes = arrayList.toArray(new String[arrayList.size()]);
        }
        string = string.replace('.', '/');
        object = new String[nlSuffixes.length];
        for (int i = 0; i < ((String[])object).length; ++i) {
            object[i] = string + nlSuffixes[i];
        }
        return object;
    }

    static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    private static void computeMissingMessages(String string, Class clazz, Map map, Field[] fieldArray, boolean bl) {
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            if ((field.getModifiers() & 0x19) != 9 || map.get(field.getName()) == ASSIGNED) continue;
            try {
                String string2 = "NLS missing message: " + field.getName() + " in: " + string;
                MessageResourceBundle.debug(string2);
                MessageResourceBundle.log(SEVERITY_WARNING, string2, null);
                if (!bl) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, string2);
                continue;
            }
            catch (Exception exception) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Error setting the missing message value for: " + field.getName(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String string, Class clazz) {
        long l = System.currentTimeMillis();
        Field[] fieldArray = clazz.getDeclaredFields();
        ClassLoader classLoader = clazz.getClassLoader();
        boolean bl = (clazz.getModifiers() & 1) != 0;
        int n = fieldArray.length;
        HashMap<String, Field> hashMap = new HashMap<String, Field>(n * 2);
        for (int i = 0; i < n; ++i) {
            hashMap.put(fieldArray[i].getName(), fieldArray[i]);
        }
        String[] stringArray = MessageResourceBundle.buildVariants(string);
        for (int i = 0; i < stringArray.length; ++i) {
            InputStream inputStream;
            InputStream inputStream2 = inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(stringArray[i]) : classLoader.getResourceAsStream(stringArray[i]);
            if (inputStream == null) continue;
            try {
                MessagesProperties messagesProperties = new MessagesProperties(hashMap, string, bl);
                messagesProperties.load(inputStream);
                continue;
            }
            catch (IOException iOException) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Error loading " + stringArray[i], iOException);
                continue;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        MessageResourceBundle.computeMissingMessages(string, clazz, hashMap, fieldArray, bl);
        MessageResourceBundle.debug("Time to load message bundle: " + string + " was " + (System.currentTimeMillis() - l) + "ms.");
    }

    static void debug(String string) {
    }

    static void log(int n, String string, Exception exception) {
    }

    static {
        SEVERITY_ERROR = 4;
        SEVERITY_WARNING = 2;
    }

    private static class MessagesProperties
    extends Properties {
        private static final int MOD_EXPECTED = 9;
        private static final int MOD_MASK = 25;
        private static final long serialVersionUID = 1L;
        private final String bundleName;
        private final Map fields;
        private final boolean isAccessible;

        public MessagesProperties(Map map, String string, boolean bl) {
            this.fields = map;
            this.bundleName = string;
            this.isAccessible = bl;
        }

        public synchronized Object put(Object object, Object object2) {
            Object object3 = this.fields.put(object, ASSIGNED);
            if (object3 == ASSIGNED) {
                return null;
            }
            if (object3 == null) {
                String string = "NLS unused message: " + object + " in: " + this.bundleName;
                MessageResourceBundle.debug(string);
                MessageResourceBundle.log(SEVERITY_WARNING, string, null);
                return null;
            }
            Field field = (Field)object3;
            if ((field.getModifiers() & 0x19) != 9) {
                return null;
            }
            try {
                if (!this.isAccessible) {
                    MessageResourceBundle.makeAccessible(field);
                }
                field.set(null, object2);
            }
            catch (Exception exception) {
                MessageResourceBundle.log(SEVERITY_ERROR, "Exception setting field value.", exception);
            }
            return null;
        }
    }
}

