/*
 * Decompiled with CFR 0.152.
 */
package com.spket.tiny;

import com.spket.tiny.Configuration;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Section {
    static final Section[] EMPTY = new Section[0];
    private Element element;
    private boolean required;
    private boolean selected;
    private String description;
    private String[] depends;
    private Section[] sections;
    private String[] resources;

    static Section[] getSections(Element element) {
        Section[] sectionArray = EMPTY;
        if (element != null) {
            ArrayList<Section> arrayList = new ArrayList<Section>();
            NodeList nodeList = element.getChildNodes();
            Configuration configuration = Configuration.getInstance();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element = Configuration.toElement(nodeList.item(i), "section");
                if (element == null || !configuration.match(element)) continue;
                arrayList.add(new Section(element));
            }
            if (arrayList.size() > 0) {
                sectionArray = new Section[arrayList.size()];
                arrayList.toArray(sectionArray);
            }
        }
        return sectionArray;
    }

    public Section(Element element) {
        this.element = element;
        if (element.hasAttribute("required")) {
            this.required = Boolean.valueOf(element.getAttribute("required"));
        }
        if (element.hasAttribute("selected")) {
            this.selected = Boolean.valueOf(element.getAttribute("selected"));
        }
    }

    public String getId() {
        if (this.element.hasAttribute("id")) {
            return this.element.getAttribute("id");
        }
        return null;
    }

    public String getLabel() {
        if (this.element.hasAttribute("label")) {
            return this.element.getAttribute("label");
        }
        return null;
    }

    public String getTitle() {
        if (this.element.hasAttribute("title")) {
            return this.element.getAttribute("title");
        }
        return this.getLabel();
    }

    public String getDescription() {
        if (this.description == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Element element = Configuration.getElement(this.element, "description");
            if (element != null) {
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (3 != node.getNodeType() && 4 != node.getNodeType()) continue;
                    stringBuffer.append(node.getNodeValue());
                }
            }
            this.description = stringBuffer.toString();
        }
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public Section[] getChildren() {
        if (this.sections == null) {
            this.sections = Section.getSections(this.element);
        }
        return this.sections;
    }

    public String getAttribute(String string) {
        if (this.element.hasAttribute(string)) {
            return this.element.getAttribute(string);
        }
        return null;
    }

    public String[] getDependencies() {
        if (this.depends == null) {
            if (this.element.hasAttribute("depends")) {
                ArrayList<String> arrayList = new ArrayList<String>(4);
                StringTokenizer stringTokenizer = new StringTokenizer(this.element.getAttribute("depends"), ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (string == null || (string = string.trim()).length() <= 0) continue;
                    arrayList.add(string);
                }
                if (arrayList.size() > 0) {
                    this.depends = new String[arrayList.size()];
                    arrayList.toArray(this.depends);
                }
            }
            if (this.depends == null) {
                this.depends = Configuration.EMPTY_STRINGS;
            }
        }
        return this.depends;
    }

    public String[] getResources() {
        if (this.resources == null) {
            ArrayList<String> arrayList = new ArrayList<String>(4);
            NodeList nodeList = this.element.getChildNodes();
            Configuration configuration = Configuration.getInstance();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Node node = nodeList.item(i);
                if (1 != node.getNodeType() || !"file".equals(node.getNodeName()) || !(element = (Element)node).hasAttribute("res") || !configuration.match(element)) continue;
                arrayList.add(element.getAttribute("res"));
            }
            if (arrayList.size() > 0) {
                this.resources = new String[arrayList.size()];
                arrayList.toArray(this.resources);
            } else {
                this.resources = Configuration.EMPTY_STRINGS;
            }
        }
        return this.resources;
    }
}

