/*
 * Decompiled with CFR 0.152.
 */
package com.spket.tiny;

import com.spket.tiny.Configuration;
import com.spket.tiny.Expand;
import com.spket.tiny.FileUtils;
import com.spket.tiny.InstallCallback;
import com.spket.tiny.InstallMonitor;
import com.spket.tiny.Library;
import com.spket.tiny.Section;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Iterator;

public class InstallTask
implements Runnable {
    private Expand expand;
    private Configuration config;
    private boolean paused;
    private boolean cancelled;
    private Thread worker;

    public InstallTask(Configuration configuration) {
        this.config = configuration;
    }

    public void start() {
        this.worker = new Thread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void run() {
        block2: {
            try {
                this.runWith();
            }
            catch (Throwable throwable) {
                InstallMonitor installMonitor;
                this.config.fatal(throwable);
                if (!this.config.isFatal() || (installMonitor = this.config.getInstallMonitor()) == null) break block2;
                installMonitor.failed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyLibraries() throws IOException {
        Library[] libraryArray = this.config.getLibraries();
        InstallMonitor installMonitor = this.config.getInstallMonitor();
        for (int i = 0; i < libraryArray.length; ++i) {
            String string;
            Library library = libraryArray[i];
            if (!library.isRequired(this.config) || (string = Configuration.replaceProperties(library.getAttribute("path"), this.config)) == null) continue;
            string = FileUtils.normalize(string);
            File file = new File(this.config.getTemporaryDir(), library.getName());
            File file2 = new File(string);
            File file3 = new File(file2, library.getName());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            FileInputStream fileInputStream = null;
            if (installMonitor != null) {
                installMonitor.begin(3, library.getName());
            }
            try {
                fileInputStream = new FileInputStream(file);
                this.expand.zip(file3, fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            if (installMonitor == null) continue;
            installMonitor.end(3, library.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWith() throws IOException {
        InstallCallback installCallback = this.config.getInstallCallback();
        InstallMonitor installMonitor = this.config.getInstallMonitor();
        this.expand = this.config.createExpand();
        if (installMonitor != null) {
            this.expand.setInstallMonitor(installMonitor);
        }
        if (installCallback != null) {
            installCallback.setConfiguration(this.config);
            installCallback.begin();
        }
        this.copyLibraries();
        File file = new File(this.config.getInstallDir());
        Iterator iterator = this.config.getInstallSections().iterator();
        while (iterator.hasNext()) {
            String string;
            this.check();
            Section section = (Section)iterator.next();
            if (installMonitor != null) {
                installMonitor.begin(1, section.getTitle());
            }
            if ((string = Configuration.replaceProperties(section.getAttribute("path"), this.config)) == null) {
                this.expand.setDest(file);
            } else {
                this.expand.setDest(new File(FileUtils.normalize(string)));
            }
            String[] stringArray = section.getResources();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.check();
                    InputStream inputStream = this.getClass().getResourceAsStream(this.config.getResource(stringArray[i]));
                    if (inputStream == null) {
                        throw new IOException("Library '" + stringArray[i] + "' not exists");
                    }
                    try {
                        this.expand.decode(inputStream);
                        continue;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
            }
            if (installMonitor == null) continue;
            installMonitor.end(1, section.getTitle());
        }
        if (!this.cancelled) {
            if (installCallback != null) {
                installCallback.end();
            }
            this.config.done();
            if (installMonitor != null) {
                installMonitor.done();
            }
        }
    }

    public synchronized void suspend() {
        this.paused = true;
        if (this.expand != null) {
            this.expand.suspend();
        }
        this.notifyAll();
    }

    public synchronized void resume() {
        this.paused = false;
        if (this.expand != null) {
            this.expand.resume();
        }
        this.notifyAll();
    }

    public synchronized void stop() {
        this.cancelled = true;
        this.paused = false;
        this.notifyAll();
        if (this.expand != null) {
            this.expand.stop();
        }
        if (this.worker != null && this.worker.isAlive()) {
            try {
                this.worker.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.worker.isAlive()) {
                System.out.println("Maybe something wrong?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() throws IOException {
        if (this.cancelled) {
            throw new InterruptedIOException();
        }
        if (this.paused) {
            InstallTask installTask = this;
            synchronized (installTask) {
                while (this.paused) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (this.cancelled) {
            throw new InterruptedIOException();
        }
    }
}

