/*
 * Decompiled with CFR 0.152.
 */
package com.spket.tiny;

import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileUtils {
    public static String normalize(String string) {
        return Path.fromOSString(string).toOSString();
    }

    public static boolean validatePath(String string) {
        if (string.length() > 0) {
            return FileUtils.validatePath(Path.fromOSString(string), false);
        }
        return false;
    }

    public static boolean validatePath(IPath iPath, boolean bl) {
        if (iPath == null) {
            return false;
        }
        if (iPath.isRoot()) {
            return false;
        }
        if (!iPath.isAbsolute()) {
            return false;
        }
        int n = iPath.segmentCount();
        if (bl) {
            return FileUtils.validateName(iPath.segment(n - 1));
        }
        for (int i = 0; i < n; ++i) {
            if (FileUtils.validateName(iPath.segment(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean validateName(String string) {
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = OS.INVALID_RESOURCE_CHARACTERS;
        for (int i = 0; i < cArray.length; ++i) {
            if (string.indexOf(cArray[i]) == -1) continue;
            return false;
        }
        return OS.isNameValid(string);
    }
}

