/*
 * Decompiled with CFR 0.152.
 */
package com.spket.tiny;

import SevenZip.Compression.LZMA.Decoder;
import com.spket.tiny.InstallMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Expand {
    private static final int BUFFER_SIZE = 8192;
    protected boolean paused;
    protected boolean cancelled;
    private File dest;
    private String unpack;
    private Thread worker;
    private InstallMonitor monitor;
    private byte[] buffer = new byte[8192];

    protected static void setFileLastModified(File file, long l) {
        file.setLastModified(l < 0L ? System.currentTimeMillis() : l);
    }

    public void setDest(File file) {
        this.dest = file;
    }

    File getDest() {
        return this.dest;
    }

    public void setCommand(String string) {
        this.unpack = string;
    }

    public void setInstallMonitor(InstallMonitor installMonitor) {
        this.monitor = installMonitor;
    }

    public synchronized void suspend() {
        this.paused = true;
    }

    public synchronized void resume() {
        this.paused = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Expand expand = this;
        synchronized (expand) {
            this.cancelled = true;
            this.paused = false;
            this.notifyAll();
        }
        if (this.worker != null && this.worker.isAlive()) {
            int n = 0;
            try {
                while (this.worker.isAlive()) {
                    this.worker.join(500L);
                    if (++n <= 10) continue;
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.worker.isAlive()) {
                System.err.println("maybe something wrong...");
            }
            this.worker = null;
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        Task task = new Task(pipedInputStream);
        this.worker = new Thread(task);
        this.worker.setDaemon(true);
        this.worker.start();
        this.decode(inputStream, pipedOutputStream);
        if (this.worker.isAlive()) {
            try {
                this.worker.join(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException(interruptedException.getMessage());
            }
            this.worker = null;
        }
        if (task.exception != null) {
            throw task.exception;
        }
    }

    public void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 5;
        byte[] byArray = new byte[n];
        if ((inputStream = new BufferedInputStream(inputStream)).read(byArray, 0, n) != n) {
            throw new IOException("input is too short");
        }
        Decoder decoder = new Decoder();
        if (!decoder.SetDecoderProperties(byArray)) {
            throw new IOException("Incorrect stream properties");
        }
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Can't read stream size");
            }
            l |= (long)n2 << 8 * i;
        }
        if (!decoder.Code(inputStream, outputStream, l)) {
            throw new IOException("Error in data stream");
        }
        outputStream.flush();
        outputStream.close();
    }

    protected void unzip(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            this.check();
            File file = null;
            String string = zipEntry.getName();
            String string2 = this.resolve(string);
            if (zipEntry.isDirectory()) {
                file = new File(string2);
                file.mkdirs();
            } else {
                File file2;
                boolean bl = string2.endsWith(".jar.pack");
                if (bl) {
                    string2 = string2.substring(0, string2.length() - 5);
                    string = string.substring(0, string.length() - 5);
                }
                if (this.monitor != null) {
                    this.monitor.begin(3, string);
                }
                if ((file2 = (file = new File(string2)).getParentFile()) != null && !file2.exists()) {
                    file2.mkdirs();
                }
                if (bl) {
                    this.unpack(file, zipInputStream);
                } else if (string2.endsWith(".zip") || string2.endsWith(".jar") || string2.endsWith(".war")) {
                    this.zip(file, zipInputStream);
                } else {
                    this.store(file, zipInputStream);
                }
                if (this.monitor != null) {
                    this.monitor.end(3, string);
                }
            }
            if (file == null) continue;
            Expand.setFileLastModified(file, zipEntry.getTime());
        }
    }

    protected String resolve(String string) {
        return new File(this.dest, string).getAbsolutePath();
    }

    protected void unpack(File file, InputStream inputStream) throws IOException {
        File file2 = null;
        try {
            file2 = new File(file.getAbsoluteFile() + ".pack");
            this.store(file2, inputStream);
            String[] stringArray = new String[]{this.unpack, file2.getAbsolutePath(), file.getAbsolutePath()};
            Process process = Runtime.getRuntime().exec(stringArray);
            int n = process.waitFor();
            if (n != 0) {
                throw new IOException(stringArray[0] + " exit with error code: " + n);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
        finally {
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File file, InputStream inputStream) throws IOException {
        byte[] byArray = this.buffer;
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream);
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            zipOutputStream.setMethod(8);
            block7: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                this.check();
                int n = 0;
                ZipInputStream zipInputStream2 = zipInputStream;
                ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                zipEntry2.setTime(zipEntry.getTime());
                zipOutputStream.putNextEntry(zipEntry2);
                while (true) {
                    if ((n = ((InputStream)zipInputStream2).read(byArray, 0, byArray.length)) == -1) continue block7;
                    zipOutputStream.write(byArray, 0, n);
                }
                break;
            }
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(File file, InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = this.buffer;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                if (n <= 0) continue;
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() throws IOException {
        if (this.cancelled) {
            throw new InterruptedIOException();
        }
        if (this.paused) {
            Expand expand = this;
            synchronized (expand) {
                while (this.paused) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }
        if (this.cancelled) {
            throw new InterruptedIOException();
        }
    }

    protected class Task
    implements Runnable {
        private InputStream in;
        private IOException exception;

        public Task(InputStream inputStream) {
            this.in = inputStream;
        }

        public void run() {
            try {
                Expand.this.unzip(this.in);
                while (this.in.read(Expand.this.buffer) != -1) {
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                try {
                    this.in.close();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
        }
    }
}

