/*
 * Decompiled with CFR 0.152.
 */
package com.spket.tiny;

import com.spket.tiny.Constants;
import com.spket.tiny.Expand;
import com.spket.tiny.InstallCallback;
import com.spket.tiny.InstallMonitor;
import com.spket.tiny.InstallTask;
import com.spket.tiny.Library;
import com.spket.tiny.NullCallback;
import com.spket.tiny.Section;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configuration
implements Constants {
    private static final int S_RUNNING = 1;
    private static final int S_CANCEL = 2;
    private static final int S_FINISHED = 3;
    static final String[] EMPTY_STRINGS = new String[0];
    private static Configuration configuration;
    private Element root;
    private String os;
    private String tmpDir;
    private String appName;
    private String executor;
    private String dir;
    private String installer;
    private int width = 506;
    private int height = 380;
    private String[] pages;
    private Section[] sections;
    private Library[] libraries;
    private int state;
    private InstallTask task;
    private Throwable exception;
    private String command;
    private boolean fSupportPack200;
    private InstallMonitor monitor;
    private InstallCallback callback;
    private Map properties = new HashMap();

    public static Configuration getInstance() {
        return configuration;
    }

    public static String getOS() {
        String string = System.getProperty("os.name");
        if (string != null) {
            string = (string = string.toLowerCase()).indexOf("windows") == -1 ? "linux" : "win32";
        }
        return string == null ? "win32" : string;
    }

    public static int parseInt(String string, int n) {
        if (string == null || string.length() == 0) {
            return n;
        }
        if ((string = string.trim()).length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    static Configuration load() throws IOException, SAXException {
        InputStream inputStream = Configuration.class.getResourceAsStream("/config.xml");
        if (inputStream == null) {
            throw new IOException("config.xml not exists");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return new Configuration(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
    }

    public static Element toElement(Node node, String string) {
        if (1 == node.getNodeType() && string.equals(node.getNodeName())) {
            return (Element)node;
        }
        return null;
    }

    public static Element getElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType() || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String replaceProperties(String string, Configuration configuration) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        Stack<StringBuffer> stack = new Stack<StringBuffer>();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block5: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    if (n == 36) {
                        n = 0;
                        stringBuffer.append('$');
                        continue block5;
                    }
                    n = c;
                    continue block5;
                }
                case '{': {
                    if (n == 36) {
                        stack.push(stringBuffer);
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append(c);
                    }
                    n = 0;
                    continue block5;
                }
                case '}': {
                    if (stack.size() > 0) {
                        StringBuffer stringBuffer2 = stringBuffer;
                        stringBuffer = (StringBuffer)stack.pop();
                        if (stringBuffer2.length() > 0) {
                            Object object = configuration.getProperty(stringBuffer2.toString());
                            if (object != null) {
                                stringBuffer.append(object.toString());
                            }
                        } else {
                            stringBuffer.append("${}");
                        }
                    } else {
                        stringBuffer.append(c);
                    }
                    n = 0;
                    continue block5;
                }
                default: {
                    if (n == 36) {
                        stringBuffer.append('$');
                    }
                    n = 0;
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private Configuration(Document document) {
        configuration = this;
        this.os = Configuration.getOS();
        this.root = document.getDocumentElement();
        this.appName = this.root.getAttribute("name");
        Element element = Configuration.getElement(this.root, "wizard");
        if (element != null) {
            if (element.hasAttribute("width")) {
                this.width = Configuration.parseInt(element.getAttribute("width"), this.width);
            }
            if (element.hasAttribute("height")) {
                this.height = Configuration.parseInt(element.getAttribute("height"), this.height);
            }
        }
        try {
            Class.forName("java.util.jar.Pack200");
            this.fSupportPack200 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fSupportPack200 = false;
        }
    }

    public String getResource(String string) {
        if (string != null && string.length() > 0 && string.charAt(0) != '/') {
            return "/datas/" + string;
        }
        return string;
    }

    private static boolean isEmpty(Object object) {
        if (object instanceof String) {
            String string = ((String)object).trim();
            return string == null || string.length() == 0;
        }
        return false;
    }

    public Object getProperty(Object object) {
        if ("INST_DIR".equals(object)) {
            return this.getInstallDir();
        }
        Object v = this.properties.get(object);
        if ((v == null || Configuration.isEmpty(v)) && ("ECLIPSE_DIR".equals(object) || "RCP_DIR".equals(object))) {
            return this.getInstallDir();
        }
        return v;
    }

    public void setProperty(Object object, Object object2) {
        if (object2 == null) {
            this.properties.remove(object);
        } else {
            this.properties.put(object, object2);
        }
    }

    public Expand createExpand() {
        if (this.fSupportPack200) {
            try {
                return (Expand)Class.forName("com.spket.tiny.ExpandPack").newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Expand expand = new Expand();
        expand.setCommand(this.command);
        return expand;
    }

    public InstallMonitor getInstallMonitor() {
        return this.monitor;
    }

    public InstallCallback getInstallCallback() {
        if (this.callback == null) {
            String string;
            Element element = Configuration.getElement(this.root, "installer");
            if (element.hasAttribute("callback") && (string = element.getAttribute("callback")).length() > 0) {
                try {
                    this.callback = (InstallCallback)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.callback == null) {
                this.callback = new NullCallback();
            }
        }
        return this.callback;
    }

    public String getTemporaryDir() {
        block3: {
            File file;
            if (this.tmpDir != null) break block3;
            this.tmpDir = System.getProperty("java.io.tmpdir");
            if (this.tmpDir == null) {
                this.tmpDir = System.getProperty("user.home");
                if (this.tmpDir == null) {
                    this.tmpDir = System.getProperty("user.dir");
                }
            }
            int n = new Random().nextInt() & 0xFFFF;
            while ((file = new File(this.tmpDir, "ist" + ++n)).exists()) {
            }
            this.tmpDir = file.getAbsolutePath();
        }
        return this.tmpDir;
    }

    public void setTemporaryDir(String string) {
        this.tmpDir = string;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getExecutor() {
        if (this.executor == null) {
            this.executor = this.root.hasAttribute("executor") ? this.root.getAttribute("executor") : "eclipse";
            if ("win32".equals(Configuration.getOS())) {
                this.executor = this.executor + ".exe";
            }
        }
        return this.executor;
    }

    public String getVersion() {
        if (this.root.hasAttribute("version")) {
            return this.root.getAttribute("version");
        }
        return "";
    }

    public String getWebsite() {
        if (this.root.hasAttribute("web")) {
            return this.root.getAttribute("web");
        }
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getInstaller() {
        return this.installer;
    }

    public boolean supportsPack200() {
        return this.fSupportPack200;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public boolean isPluginMode() {
        return Boolean.TRUE == this.getProperty("PLUGIN_MODE");
    }

    public boolean isLinkedMode() {
        if (this.isPluginMode()) {
            File file = new File(this.getInstallDir());
            return !file.equals(new File((String)this.getProperty("ECLIPSE_DIR")));
        }
        return false;
    }

    public boolean isCanceled() {
        return this.state == 2;
    }

    public void cancel() {
        this.state = 2;
        if (this.task != null) {
            this.task.stop();
            this.task = null;
        }
    }

    public void start(InstallMonitor installMonitor) {
        if (this.state == 0) {
            this.state = 1;
            this.monitor = installMonitor;
            this.task = new InstallTask(this);
            this.task.start();
        }
    }

    public boolean isStarted() {
        return this.state == 1;
    }

    public boolean isFatal() {
        return this.exception != null;
    }

    public boolean isFinished() {
        return this.state == 3;
    }

    public void fatal(Throwable throwable) {
        if (this.state == 1) {
            this.exception = throwable;
        }
    }

    public Throwable getThrowable() {
        return this.exception;
    }

    public void done() {
        if (this.state == 0 || this.state == 1) {
            this.state = 3;
        }
    }

    public void suspend() {
        if (this.task != null) {
            this.task.suspend();
        }
    }

    public void resume() {
        if (this.task != null) {
            this.task.resume();
        }
    }

    public String getIcon() {
        Element element = Configuration.getElement(this.root, "image");
        if (element != null) {
            return element.getAttribute("icon");
        }
        return null;
    }

    public String getBanner() {
        Element element = Configuration.getElement(this.root, "image");
        if (element != null && element.hasAttribute("banner")) {
            return element.getAttribute("banner");
        }
        return null;
    }

    public Library[] getLibraries() {
        if (this.libraries == null) {
            ArrayList<Library> arrayList = null;
            Element element = Configuration.getElement(this.root, "installer");
            this.installer = element.getAttribute("class");
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            if (n > 0) {
                arrayList = new ArrayList<Library>(n);
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (1 != node.getNodeType() || !"classes".equals(node.getNodeName()) || !this.match(element = (Element)node)) continue;
                    arrayList.add(new Library(element));
                }
            }
            if (arrayList.size() > 0) {
                this.libraries = new Library[arrayList.size()];
                arrayList.toArray(this.libraries);
            } else {
                this.libraries = new Library[0];
            }
        }
        return this.libraries;
    }

    public boolean match(Element element) {
        if (element.hasAttribute("os")) {
            return this.os.equals(element.getAttribute("os"));
        }
        return true;
    }

    public String[] getPages() {
        if (this.pages == null) {
            this.pages = EMPTY_STRINGS;
            Element element = Configuration.getElement(this.root, "wizard");
            if (element != null && element.hasChildNodes()) {
                NodeList nodeList = element.getChildNodes();
                ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    element = Configuration.toElement(node, "page");
                    if (element == null || !element.hasAttribute("class")) continue;
                    arrayList.add(element.getAttribute("class"));
                }
                if (arrayList.size() > 0) {
                    this.pages = new String[arrayList.size()];
                    arrayList.toArray(this.pages);
                }
            }
        }
        return this.pages;
    }

    public Section[] getSections() {
        if (this.sections == null) {
            this.sections = Section.getSections(Configuration.getElement(this.root, "sections"));
        }
        return this.sections;
    }

    public String getInstallDir() {
        if (this.dir == null) {
            this.dir = this.getDefaultDir();
        }
        return this.dir;
    }

    public boolean hasInstallDir() {
        return this.dir != null;
    }

    protected String getDefaultDir() {
        String string;
        this.dir = this.root.hasAttribute("dir") ? this.root.getAttribute("dir") : "eclipse";
        if ("win32".equals(this.os)) {
            string = "C:\\";
        } else {
            string = System.getProperty("user.home");
            if (string == null) {
                string = "/opt";
            }
        }
        return new File(string, this.dir).getAbsolutePath();
    }

    public void setInstallDir(String string) {
        this.dir = string;
    }

    public Set getInstallSections() {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Section[] sectionArray = this.getSections();
        this.list(hashMap, sectionArray);
        for (int i = 0; i < sectionArray.length; ++i) {
            this.list(sectionArray[i], linkedHashSet, hashSet, hashMap, false);
        }
        return linkedHashSet;
    }

    protected void list(Map map, Section[] sectionArray) {
        for (int i = 0; i < sectionArray.length; ++i) {
            Section section = sectionArray[i];
            String string = section.getId();
            if (string != null) {
                map.put(string, section);
            }
            this.list(map, section.getChildren());
        }
    }

    protected void list(Section section, Set set, Set set2, Map map, boolean bl) {
        int n;
        Object[] objectArray;
        if (set2.contains(section)) {
            return;
        }
        if (bl || this.isRequired(section) || section.isSelected()) {
            set2.add(section);
            objectArray = section.getDependencies();
            for (n = 0; n < objectArray.length; ++n) {
                Section section2 = (Section)map.get(objectArray[n]);
                if (section2 == null) {
                    System.out.println("Section '" + (String)objectArray[n] + "' not exists");
                    continue;
                }
                this.list(section2, set, set2, map, true);
            }
            set.add(section);
        }
        if ((objectArray = section.getChildren()).length > 0) {
            for (n = 0; n < objectArray.length; ++n) {
                this.list((Section)objectArray[n], set, set2, map, false);
            }
        }
    }

    protected boolean isRequired(Section section) {
        String string = Configuration.replaceProperties(section.getAttribute("required"), this);
        if (string != null) {
            return Boolean.valueOf(string);
        }
        return false;
    }
}

