#!/bin/sh

temp_net_ip=''
get_net_ip()
{
	#echo $1
	#echo $2
	for i in 1 2 3 4; do
		cut_ip=$(echo $1 | cut -d '.' -f$i)
		cut_mask=$(echo $2 | cut -d '.' -f$i)
		let "cut_net_ip=cut_ip & cut_mask"
		if [ "$temp_net_ip" == '' ]; then
			temp_net_ip="$cut_net_ip"
		else
			temp_net_ip="$temp_net_ip.$cut_net_ip"
		fi
	done
}

#获取内部(桥接)网络IP和掩码
inner_net_ip=$(netstat -nr | grep 'br-lan' | tr -s ' ' | cut -d ' ' -f1)
inner_net_mask=$(netstat -nr | grep 'br-lan' | tr -s ' ' | cut -d ' ' -f3)
get_net_ip $1 $inner_net_mask

#如果要加添的路由和内部桥接的网络是同一个网络，则不添另这个路由
#否则则添加路由，以防p2p时走虚拟网卡
if [ "$temp_net_ip" != "$inner_net_ip" ]; then
	gw_ip=$(netstat -nr | grep '^0.0.0.0' | tr -s ' ' | cut -d ' ' -f2)
	sudo route -n delete -host $1
	sudo route -n add -host $1 $gw_ip 
#	route del -host $1
#	route add -host $1 gw "$gw_ip"
fi
