#!/bin/sh

echo "ip=$1"
echo "lan_ip=$2"
echo "lan_mask=$3"

ip="$1"
lan_ip="$2"
lan_mask="$3"

if [ "$ip" == "" ]; then
	exit 1
fi

if [ "$lan_ip" == '' ]; then
	exit 1
fi

if [ "$lan_mask" == '' ]; then
	exit 1
fi

#函数：根据mask和ip获取网络ip
net_ip=''
get_net_ip()
{
	#echo $1
	#echo $2
	for i in 1 2 3 4; do                                                       
		cut_ip=$(echo $1 | cut -d '.' -f$i)                           
		cut_mask=$(echo $2 | cut -d '.' -f$i)                       
		let "cut_net_ip=cut_ip & cut_mask"                                 
		if [ "$net_ip" == '' ]; then                                       
			net_ip="$cut_net_ip"                                       
		else                                        
			net_ip="$net_ip.$cut_net_ip"        
		fi                                          
	done   
}

#如果添加的路由与现有路由网路IP一样，则不添加
get_net_ip "$lan_ip" "$lan_mask"
if [ $(netstat -nr | grep "$net_ip" | wc -l) -ne 0 ]; then
	now_time=$(date)
	echo "[$now_time] same route net ip $net_ip" > /tmp/orayboxvpn_script_err
	exit 1
fi

#添加路由
echo "route add -net $net_ip netmask $lan_mask gw $ip"
route -n add -net $net_ip -netmask $lan_mask  $ip

