#!/bin/sh

echo "ip=$1"
echo "lan_ip=$2"
echo "lan_mask=$3"

ip="$1"
lan_ip="$2"
lan_mask="$3"

if [ "$ip" == '' ]; then
	exit 1
fi

if [ "$lan_ip" == '' ]; then
	exit 1
fi

if [ "$lan_mask" == '' ]; then
	exit 1
fi

net_ip=''
for i in 1 2 3 4; do
	cut_ip=$(echo $lan_ip | cut -d '.' -f$i)
	cut_mask=$(echo $lan_mask | cut -d '.' -f$i)
	let "cut_net_ip=cut_ip & cut_mask"
	if [ "$net_ip" == '' ]; then
		net_ip="$cut_net_ip"
	else
		net_ip="$net_ip.$cut_net_ip"
	fi
done
echo "route -n delete -net $net_ip -netmask $lan_mask $ip"
sudo route -n delete -net $net_ip -netmask $lan_mask $ip

