#!/bin/bash

function unloadplist()
{
   launchctl unload /Library/LaunchAgents/com.oray.oraybox.agent.plist 2>/dev/null
   launchctl unload /Library/LaunchDaemons/com.oray.oraybox.plist  2>/dev/null
}


function loadplist()
{
   sudo chown root:wheel /Library/LaunchDaemons/PgyVistorDaemon.sh 
   sudo chown root:wheel /Library/LaunchDaemons/com.oray.oraybox.plist 
   sudo chmod a+x /Library/LaunchDaemons/PgyVistorDaemon.sh
   sudo chmod 644 /Library/LaunchDaemons/com.oray.oraybox.plist
   launchctl load -w /Library/LaunchDaemons/com.oray.oraybox.plist 
}

function loadtuntap()
{
   # unload an old extension (might fail)
   kextunload /Library/Extensions/tap.kext 2>/dev/null
   kextunload /Library/Extensions/tun.kext 2>/dev/null

   # Fix ownership and permissions. PackageMaker gets this wrong *sigh*
   chown -R root:wheel /Library/StartupItems/tap
   chmod -R u=rwX,g=rX,o=rX /Library/StartupItems/tap
   chown -R root:wheel /Library/StartupItems/tun
   chmod -R u=rwX,g=rX,o=rX /Library/StartupItems/tun
   chown -R root:wheel /Library/Extensions/tap.kext
   chmod -R u=rwX,g=rX,o=rX /Library/Extensions/tap.kext
   chown -R root:wheel /Library/Extensions/tun.kext
   chmod -R u=rwX,g=rX,o=rX /Library/Extensions/tun.kext

   # load the new version
   kextload /Library/Extensions/tap.kext 2>/dev/null
   kextload /Library/Extensions/tun.kext 2>/dev/null

   return 0
}

if [ $UID -ne 0 ]; then
    echo "请使用\"sudo sh install.sh\"来安装"
    exit 1
fi

echo "安装中，请稍侯..."

unloadplist

killall OrayBoxVPNForMac 2>/dev/null
killall PgyVistorForMac  2>/dev/null

mkdir -p /Applications/OrayBox
mkdir -p /Applications/OrayBox/script

cp -f  ./install_dir/tap			/Library/StartupItems/
cp -f  ./install_dir/tun			/Library/StartupItems/
#cp -rf ./install_dir/tap.kext			/Library/Extensions/
#cp -rf ./install_dir/tun.kext			/Library/Extensions/
VERSION=$(sw_vers | grep ProductVersion | awk -F "." '{print $2}')
if [ $VERSION -lt 9 ]; then
	cp -rf ./install_dir/driver_for_10.8/tap.kext	/Library/Extensions/
	cp -rf ./install_dir/driver_for_10.8/tun.kext	/Library/Extensions/
else
	cp -rf ./install_dir/driver_for_10.10/tap.kext	/Library/Extensions/
	cp -rf ./install_dir/driver_for_10.10/tun.kext	/Library/Extensions/
fi 

cp -f  ./install_dir/config.ini			/Applications/OrayBox/
#cp -f  ./install_dir/com.oray.oraybox.plist     /Library/LaunchDaemons/
#cp -rf ./install_dir/PgyVistorForMacStartup     /Library/StartupItems/
cp -f  ./install_dir/com.oray.oraybox.plist 	/Library/LaunchDaemons/
cp -f  ./PgyVistorForMac  	         	/Applications/OrayBox/
cp -f  ./install_dir/OrayBoxVPNForMac           /Applications/OrayBox/
cp -f  ./install_dir/PgyVistorDaemon.sh	   	/Library/LaunchDaemons/

cp -rf ./install_dir/script		        /Applications/OrayBox/

loadtuntap
loadplist

echo "安装成功！"
