/*
 * Copyright (c) 2010, NanChang BangTeng Inc
 *
 * kangle web server              http://www.kanglesoft.com/
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *  See COPYING file for detail.
 *
 *  Author: KangHongjiu <keengo99@gmail.com>
 */
#ifndef FTP_H_SADFLKJASDLFKJASDLFKJ234234234
#define FTP_H_SADFLKJASDLFKJASDLFKJ234234234
#include <string>
#include <vector>
#include <stdlib.h>
#include "global.h"

#include "lib.h"
#include "KSocket.h"

#include "log.h"
#include "malloc_debug.h"
#include "KBuffer.h"
#include "KHttpRequest.h"
#include "KTable.h"
#include "utils.h"
#include "KHttpObjectParserHook.h"
#include "KVirtualHost.h"
#include "KSendable.h"
#include "KEnvInterface.h"
#include "KPipeStream.h"
#include "KSelector.h"
#include "malloc_debug.h"
#include "KPathRedirect.h"
/////////[305]


enum {
	LOAD_HEAD_SUCCESS, LOAD_HEAD_FAILED, LOAD_HEAD_RETRY
};
bool is_attr(KHttpHeader *av, const char *attr);
bool asyncSendHttpObject(KHttpRequest *rq);
bool asyncSendCache(KHttpRequest *context);
bool asyncLoadHttpObject(KHttpRequest *context);
bool async_http_start(KHttpRequest *context);
bool sendHttpObject(KHttpRequest *rq, KHttpObject *obj);
void sendMemoryObject(KHttpRequest *rq,KHttpObject *obj);
bool send_not_modify_from_mem(KHttpRequest *rq);
int url_decode(char *url_msg, int url_len = 0,int *flag=NULL,bool space2plus=true);
char *url_encode(const char *s, size_t len, size_t *new_length);
std::string url_encode(const char *s, size_t len = 0);
bool parse_url(const char *src, KUrl *url);
bool sync_send_post_data(KHttpRequest *rq);
bool try_send_request(KHttpRequest *rq,bool skip_header = false);
void stage_rdata_end(KHttpRequest *rq,StreamState result);
bool send_error(KHttpRequest *rq, KHttpObject *obj,int code, const char* reason);
void prepare_load_body(KHttpRequest *rq);
bool chunked_send(KSendable *socket, const char *str, int len);
bool chunked_send(KSendable *socket, buff *buf, int len);
bool send_chunked_head(KSendable *socket, int len);
StreamState send_buff(KSendable *socket, buff *buf , INT64 &start,INT64 &send_len);
bool send_auth(KHttpRequest *rq,KBuffer *body=NULL);
bool check_need_gzip(KHttpRequest *rq, KHttpObject *obj);
bool stageContentType(KHttpRequest *rq,KHttpObject *obj);
bool build_obj_header(KHttpRequest *rq, KHttpObject *obj, KBuffer &b,
		INT64 content_len, INT64 &start, INT64 &send_len);
bool build_obj_header(KHttpRequest *rq, KHttpObject *obj, KBuffer &b,
		INT64 content_len);
void send_redirect(KHttpRequest *rq,const char *url,int code=STATUS_FOUND);
void send_redirect(KHttpRequest *rq, const char *url,int &code, KBuffer &s);
bool https_start(KHttpRequest *rq);
bool http_start(KHttpRequest *rq);
bool processHttpRequest(KHttpRequest *rq);
bool manage_start(KHttpRequest *rq);

void insert_via(KHttpRequest *rq, KWStream &s,
		char *old_via = NULL);
bool make_webdav_destination_env(KHttpRequest *rq,KRedirect *rd,KEnvInterface *env,bool chrooted);
bool make_http_env(KHttpRequest *rq, KBaseRedirect *rd,time_t lastModified,KFileName *file,KEnvInterface *env, bool chrooted=false);
KWStream *makeWriteStream(KHttpRequest *rq,KHttpObject *obj,KWStream *st,bool &autoDelete);
bool stored_obj(KHttpObject *obj,KHttpObject *old_obj,int list_state);
bool stored_obj(KHttpRequest *rq, KHttpObject *obj,KHttpObject *old_obj);
bool adjust_range(KHttpRequest *rq,INT64 &len);
bool send_http(KHttpRequest *rq, KHttpObject *obj, int code,const char *header, KBuffer *body = NULL);
void handleUpstreamRecvedHead(KHttpRequest *rq);
void handleTempFileReadPost(KSelectable *st,int got);
void handleError(KHttpRequest *rq,int code,const char *msg) ;
void set_obj_size(KHttpObject *obj, INT64 content_length);
inline int checkResponse(KHttpRequest *rq,KHttpObject *obj, int flag, KAccess *access) {
	if (TEST(obj->index.flags,flag)) {
		if (TEST(obj->index.flags,FLAG_FILTER_DENY)) {
			return JUMP_DENY;
		}
		return JUMP_ALLOW;
	}
	SET(obj->index.flags,flag);
	int action = access->check(rq, obj);
#if 0
	if (action != JUMP_DENY) {
		if (rq->globalFilter.size() > 0
#ifdef ENABLE_USER_ACCESS
				|| rq->userFilter.size() > 0
#endif
		) {
			rq->getCharset(obj->data->headers);
		}
	}
#endif
	return action;
}

inline int checkResponse(KHttpRequest *rq,KHttpObject *obj) {
	int action = JUMP_ALLOW;
	KMutex *lock = obj->getLock();
	lock->Lock();
	action = checkResponse(rq,obj, GLOBAL_KEY_CHECKED, &kaccess[RESPONSE]);
#ifndef HTTP_PROXY
#ifdef ENABLE_USER_ACCESS
	if (action == JUMP_ALLOW && rq->svh) {
		action = rq->svh->vh->checkResponse(rq);
	}
#endif
#endif
	if (action == JUMP_DENY) {
		if (obj->refs == 1) {
			KBuffer::destroy(obj->data->bodys);
			obj->data->bodys = NULL;
			set_obj_size(obj, 0);
		}
		SET(obj->index.flags,FLAG_FILTER_DENY);
	}
	lock->Unlock();
	return action;
}
inline bool check_need_gzip(KHttpRequest *rq, KHttpObject *obj) {
        //objΪѾѹ߱˲ѹѹ
		if (TEST(obj->index.flags,FLAG_GZIP)) {
				return false;
		}
        //objж,ѹ
        if (obj->refs > 1) {
                return false;
        }
        //ͻ˲֧ѹʽѹ
        if (!TEST(rq->flags,RQ_HAS_GZIP))
                return false;
        //status_code206ʾǲʱҲѹ,
        //עûоϸ֤
        if (obj->data->status_code == STATUS_CONTENT_PARTIAL) {
                return false;
        }
        if (TEST(obj->index.flags,FLAG_DEAD) && conf.only_gzip_cache == 1) {
                return false;
        }
        //ΪҪѹ򷵻Ҫѹ
        if (TEST(obj->index.flags,FLAG_NEED_GZIP)) {
                return true;
        }
        return false;
}

//ڶк󣬴Ѿ
inline void processReadyedRequest(KHttpRequest *rq)
{
	if (!TEST(rq->flags,RQ_SYNC)){//q->op==STAGE_OP_ASYNC) {
		rq->fetchObj->open(rq);
		return;
	}
	if (!m_thread.start(rq,stage_sync)) {
		stageEndRequest(rq);
	}
}
//Ķ,Դص㴦Ƿ
inline void processQueueRequest(KHttpRequest *rq)
{
	if (rq->fetchObj->isSync()) {
		rq->selector->removeRequest(rq);
		SET(rq->flags,RQ_SYNC);
	} else {
		CLR(rq->flags,RQ_SYNC);
	}
#ifdef ENABLE_REQUEST_QUEUE
	KRequestQueue *queue =&globalRequestQueue;
#ifdef ENABLE_VH_QUEUE
	if (rq->svh && rq->svh->vh->queue) {
		queue = rq->svh->vh->queue;
	}
#endif
	if(!queue->start(rq)){
		if(TEST(rq->flags,RQ_SYNC)){
			send_error(rq,NULL,STATUS_SERVICE_UNAVAILABLE,"Server is busy.");
			stageEndRequest(rq);
		} else {
			send_error(rq,NULL,STATUS_SERVICE_UNAVAILABLE,"Server is busy.");
		}
		return;	
	}
	return;
#else
	processReadyedRequest(rq);
	return;
#endif
}
inline void processNotCacheRequest(KHttpRequest *rq)
{
		/////////[306]
#ifdef ENABLE_TF_EXCHANGE
	if (!TEST(rq->workModel,WORK_MODEL_INTERNAL) && rq->content_length>0) {
		//postݣҪǰôrq->tf
		if (TEST(rq->flags,RQ_TEMPFILE_HANDLED)) {
			if (rq->tf==NULL) {
				asyncLoadHttpObject(rq);
				return;
			}
		} else {
			SET(rq->flags,RQ_TEMPFILE_HANDLED);
			kassert(rq->tf==NULL);
			if (conf.tmpfile<=0) {
				asyncLoadHttpObject(rq);
				return;
			}
			rq->tf = new KTempFile;
		}		
		kassert(rq->tf!=NULL);
		INT64 left_read = rq->left_read - rq->parser.bodyLen;
		if (left_read>0) {
			//post
			if (rq->content_length>conf.max_post_size) {
				send_error(rq,NULL,STATUS_BAD_REQUEST,"POST size is too big");
				return;
			}
			//rq->tf = new KTempFile;
			rq->tf->init(left_read);
			stageReadTempFile(rq);
			return;
		}
	}
#endif
	asyncLoadHttpObject(rq);
}
//׼ԴԴص㴦󣬿Ƿʱļ
inline void processRequest(KHttpRequest *rq)
{
	kassert(rq->fetchObj!=NULL);

#ifdef ENABLE_REQUEST_QUEUE
	if(TEST(rq->workModel,WORK_MODEL_MANAGE|WORK_MODEL_INTERNAL) || !rq->fetchObj->needQueue()){
		if (rq->fetchObj->isSync()) {
			rq->selector->removeRequest(rq);
			SET(rq->flags,RQ_SYNC);
		} else {
			CLR(rq->flags,RQ_SYNC);
		}
		//̨ڲãŶ
		processReadyedRequest(rq);
		return;
	}
#endif
#ifdef ENABLE_TF_EXCHANGE
	/*
	* Ϊ,KTempFileĴطPOSTݣҪǰôprocessNotCacheRequest
	* postݣڴ˴
	*/
    if (!TEST(rq->flags,RQ_TEMPFILE_HANDLED) && conf.tmpfile>0 && rq->tf==NULL) {
		rq->tf = new KTempFile;
	}
#endif
	processQueueRequest(rq);
}
/*
жǷأop=STAGE_OP_WRITE,STAGE_OP_TF_WRITE

true أ
false û
*/
inline bool limitWrite(KHttpRequest *rq,int op=STAGE_OP_WRITE)
{
	if (rq->slh==NULL) {
		return false;
	}
	int len = 0;
	//õͳ
	if (op==STAGE_OP_WRITE) {
		rq->get_write_buf(len);	
	} else {
#ifdef ENABLE_TF_EXCHANGE
		kassert(rq->tf!=NULL);
		rq->tf->readBuffer(len);
#endif
	}
	//٣㷢ʱ
	INT64 sendTime = rq->getSendTime((int)len);
	if (sendTime>0) {
		rq->selector->addBlock(rq,op,sendTime);
		return true;
	}
	return false;
}
inline void limitWrite(KHttpRequest *rq,int op,int len)
{
	if (rq->slh) {		
		//٣㷢ʱ
		INT64 sendTime = rq->getSendTime((int)len);
		if (sendTime>0) {
			rq->selector->addBlock(rq,op,sendTime);
			return;
		}
	}
	rq->selector->addRequest(rq,KGL_LIST_RW,op);
}
inline bool limitWrite(KHttpRequest *rq,KSelectable *st,int op,int len)
{
	if (rq->slh) {		
		//٣㷢ʱ
		INT64 sendTime = rq->getSendTime((int)len);
		if (sendTime>0) {
			rq->selector->addBlock(rq,st,op,sendTime);
			return true;
		}
	}
	return false;
}
inline void attach_av_pair_to_buff(const char* attr, const char *val, KBuffer *buffer) {
	assert(attr && val && buffer);
	if (*attr) {
		buffer->write_all(attr, strlen(attr));
		buffer->write_all(": ", 2);
		buffer->write_all(val, strlen(val));
	}
	buffer->write_all("\r\n", 2);
}
/*
obj is not expire
*/
inline bool async_send_valide_object(KHttpRequest *rq, KHttpObject *obj)
{
	rq->status_code = STATUS_OK;
	if (TEST(rq->flags,RQ_HAS_IF_MOD_SINCE|RQ_IF_RANGE)) {
		time_t useTime = obj->index.last_modified;
		if (useTime <= 0) {
			useTime = obj->index.last_verified;
		}
		if (rq->if_modified_since >= useTime) {
			//not change
			if (TEST(rq->flags,RQ_HAS_IF_MOD_SINCE)){
				rq->status_code = STATUS_NOT_MODIFIED;
			}
		} else if (TEST(rq->flags,RQ_IF_RANGE)) {
			CLR(rq->flags,RQ_HAVE_RANGE);
		}
	}
	bool result;
	if (rq->status_code != STATUS_NOT_MODIFIED) {
		result = asyncSendHttpObject(rq);
	}else{
		result = send_not_modify_from_mem(rq);
	}
	return result;
}
//objǷ1
inline bool check_object_expiration(KHttpRequest *rq,KHttpObject *obj) {
	assert(obj);
	if (!obj){
		return false;
	}
	if (TEST(obj->index.flags,OBJ_MUST_REVALIDATE)) {
		//must-revalidate,ÿζҪԴ֤
		return true;
	}
	unsigned freshness_lifetime;
	if (TEST(obj->index.flags ,ANSW_HAS_MAX_AGE|ANSW_HAS_EXPIRES)){
		freshness_lifetime = obj->index.max_age;
	} else {
		freshness_lifetime = conf.refresh_time;
	}
	if (TEST(rq->filter_flags,RF_DOUBLE_CACHE_EXPIRE)) {
		//˫ʱ䣬ǿˢ
		freshness_lifetime = freshness_lifetime<<1;
		CLR(rq->flags,RQ_HAS_NO_CACHE);
	}
	//debug("current_age=%d,refreshness_lifetime=%d\n",current_age,freshness_lifetime);
	unsigned current_age = obj->getCurrentAge(kgl_current_sec);
	if (current_age >= freshness_lifetime){
#ifdef ENABLE_STATIC_ENGINE
		//Ǿ̬ҳ,Ҫɹ
		CLR(obj->index.flags,OBJ_IS_STATIC2);
#endif
		return true;
	}
	return false;
}
inline void asyncSendCache2(KHttpRequest *rq,KHttpObject *obj)
{
	if (check_object_expiration(rq,obj)) {
		goto revalidate;
	}
	if (TEST(rq->flags , RQ_HAS_NO_CACHE)) {
		goto revalidate;
	}
	async_send_valide_object(rq,obj);
	return;
	revalidate:
#ifdef ENABLE_FORCE_CACHE
	if (TEST(obj->index.flags,OBJ_IS_STATIC2)){
		async_send_valide_object(rq,obj);
		return;
	}
#endif
	assert(obj && rq->ctx->old_obj==NULL);
	rq->ctx->old_obj = obj;
	rq->ctx->obj = new KHttpObject(rq);
	rq->ctx->new_object = true;
	asyncLoadHttpObject(rq);
}
#endif
