/*
 * Copyright (c) 2010, NanChang BangTeng Inc
 *
 * kangle web server              http://www.kanglesoft.com/
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *  See COPYING file for detail.
 *
 *  Author: KangHongjiu <keengo99@gmail.com>
 */
#ifndef KVIRTUALHOST_H
#define KVIRTUALHOST_H
/**
 * virtual host
 */
#include <time.h>
#include <string>
#include <map>
#include "global.h"
#include "KLogElement.h"
//#include "KLocalFetchObject.h"
#include "KFileName.h"
#include "KCountable.h"
#include "KVirtualHost.h"
#include "KSubVirtualHost.h"
#include "KPathRedirect.h"
#include "KAccess.h"
#include "KUserManageInterface.h"
#include "utils.h"
#include "KBaseVirtualHost.h"
#include "KRequestQueue.h"
#include "extern.h"
#include "KFlowInfo.h"

class KTempleteVirtualHost;
/**
* Ը
*/
class KAttributeHelper
{
public:
	KAttributeHelper(std::map<std::string,std::string> *attribute)
	{
		this->attribute = attribute;
	}
	std::map<std::string,std::string> *getAttribute()
	{
		return attribute;
	}
	bool getValue(const char *name,std::string &value)
	{
		if(attribute==NULL){
			return false;
		}
		std::map<std::string,std::string>::iterator it;
		it = attribute->find(name);
		if(it==attribute->end()){
			return false;
		}
		value = (*it).second;
		return true;
	}
	void setValue(const char *name,const char *value)
	{
		attribute->insert(std::pair<std::string,std::string>(name,value));
	}
private:
	std::map<std::string,std::string> *attribute;
};
/**
* 
*/
class KConnectionLimit : public KCountable
{
public:
	KConnectionLimit()
	{
		refs = 1;
		cur_connect = 0;
	}
	bool addConnection(int max_connect)
	{
		refsLock.Lock();
		if(cur_connect >= max_connect){
			refsLock.Unlock();
			return false;
		}
		cur_connect ++;
		refsLock.Unlock();
		return true;
	}
	void releaseConnection()
	{
		refsLock.Lock();
		cur_connect --;
		refsLock.Unlock();
	}
	int getConnectionCount()
	{
		int count ;
		refsLock.Lock();
		count = cur_connect;
		refsLock.Unlock();
		return count;
	}
private:
	int cur_connect;
};
/**
* 
*/
class KVirtualHost: public KBaseVirtualHost, public KCountable {
public:
	KVirtualHost();
	virtual ~KVirtualHost();
	bool setDocRoot(std::string &docRoot);
	KSubVirtualHost *getFirstSubVirtualHost() {
		if (hosts.size() == 0) {
			return NULL;
		}
		return *(hosts.begin());
	}
	virtual bool isTemplete()
	{
		return false;
	}
	friend class KHttpRequest;
	friend class KNsVirtualHost;
	friend class KVirtualHostManage;
	bool browse;
	//bool updatedFlag;
	/*
	 * ģ
	 */
	KTempleteVirtualHost *tvh;
#ifdef ENABLE_USER_ACCESS	
	int checkRequest(KHttpRequest *rq);
	int checkResponse(KHttpRequest *rq);
	int checkPostMap(KHttpRequest *rq);
	std::string user_access;
#endif
	std::string doc_root;
	std::string orig_doc_root;
#ifdef ENABLE_VH_LOG_FILE
	KLogElement *logger;
	std::string logFile;

	//
	void setLogFile(std::string &path,
			std::map<std::string, std::string>&attribute);
	void setLogFile(KAttributeHelper *ah,KVirtualHost *tm=NULL);
#endif
	/*
	 * ǷҪɱӦĽ,trueҪɱ̣ɱ
	 */
	bool caculateNeedKillProcess(KVirtualHost *ov);
#ifdef ENABLE_VH_QUEUE
	void initQueue(KVirtualHost *ov)
	{
		if(queue){
			return;
		}
		if(max_worker>0){
			if(ov){
				queue = ov->queue;
			}
			if(queue){
				queue->addRef();
			}else{
				queue = new KRequestQueue;
			}
			queue->set(max_worker,max_queue);
		}
	}
	unsigned getWorkerCount();
	unsigned getQueueSize();
	KRequestQueue *queue;
	unsigned max_worker;
	unsigned max_queue;
#endif
#ifdef ENABLE_VH_RS_LIMIT
	void setSpeedLimit(const char *speed_limit_str,KVirtualHost *ov);
	void setSpeedLimit(int speed_limit,KVirtualHost *ov);
	
	int getConnectCount();
	bool addConnection() {
		if(cur_connect==NULL || max_connect==0){
			return true;
		}
		return cur_connect->addConnection(max_connect);
	}
	void releaseConnection() {
		if(cur_connect){
			cur_connect->releaseConnection();
		}
	}
	void initConnect(KVirtualHost *ov)
	{
		if(cur_connect){
			return;
		}
		if(max_connect>0){
			if(ov){
				cur_connect = ov->cur_connect;
			}
			if(cur_connect){
				cur_connect->addRef();
			}else{
				cur_connect = new KConnectionLimit;
			}
		}
	}
	//ǰϢ
	KConnectionLimit *cur_connect;
	//
	int max_connect;
	//
	int speed_limit;
	//ǰϢ
	KSpeedLimit *sl;
#endif
	/////////[99]
	/*
	״̬0ʾͨ״̬ʾͣ״̬
	*/
	int status;
	KFetchObject *findPathRedirect(KHttpRequest *rq, KFileName *file,const char *path,
			bool fileExsit,bool &result);
	/*
	 check if a file will map to the rd
	 */
	bool isPathRedirect(KHttpRequest *rq, KFileName *file, bool fileExsit,
			KRedirect *rd);
	KFetchObject *findFileExtRedirect(KHttpRequest *rq, KFileName *file,
			bool fileExsit,bool &result);
	KFetchObject *findDefaultRedirect(KHttpRequest *rq,KFileName *file,bool fileExsit);
	//int instance_id;
	std::string name;
	bool ext;
	bool db;
#ifdef ENABLE_BASED_PORT_VH
	std::list<u_short> ports;
	std::list<std::string> binds;
#endif
	std::list<KSubVirtualHost *> hosts;
#ifdef ENABLE_VH_RUN_AS
	std::string add_dir;
#ifndef _WIN32
	bool chroot;
#endif
	bool setRunAs(std::string user, std::string group);


	int id[2];
	/*
	 * run user
	 */
	std::string user;
	/*
	 * run group
	 */
	std::string group;
	std::string getUser()
	{
		return user;
	}
#ifdef _WIN32
	HANDLE logon(bool &result);
	Token_t getLogonedToken(bool &result)
	{
		result = logoned;
		return token;
	}
#endif
	Token_t createToken(bool &result);
	Token_t getProcessToken(bool &result);
	static void createToken(Token_t token);	
#else
	/*
	ڲ֧ûʱһȫû
	*/
	std::string getUser() {
		return "-";
	}
#endif
	/*
	Ӧó
	*/
	int app;
	bool ip_hash;
	std::vector<std::string> apps;
	//app use share with other user
	int app_share;
	void setApp(int app);
	std::string getApp(KHttpRequest *rq);
	static void closeToken(Token_t token);
	virtual void buildXML(std::stringstream &s);
	bool inherit;
	//Ƿִ֧
	bool concat;
	/*
	 Ƿ
	 FOLLOW_LINK_NO  
	 FOLLOW_LINK_ALL Ǹ
	 FOLLOW_LINK_OWN ֻѵ
	 */
	/*
	int followlink;
	void setFollowLink(const char *followLink) {
		if (strcasecmp(followLink, "all") == 0) {
			followlink = FOLLOW_LINK_ALL;
		} else if (strcasecmp(followLink, "no") == 0) {
			followlink = FOLLOW_LINK_NO;
		} else if (strcasecmp(followLink, "own") == 0) {
			followlink = FOLLOW_LINK_OWN;
		} else {
			followlink = FOLLOW_LINK_ALL;
		}
	}
	const char *getFollowLink() {
		switch (followlink) {
		case FOLLOW_LINK_ALL:
			return "all";
		case FOLLOW_LINK_NO:
			return "no";
		case FOLLOW_LINK_OWN:
			return "own";
		}
		return "unknow";
	}
	*/
	bool loadApiRedirect(KApiPipeStream *st,int workType);
	bool saveAccess();
	void setAccess(std::string access_file);
	std::string htaccess;
	KAccess access[2];
#ifdef SSL_CTRL_SET_TLSEXT_HOSTNAME
	std::string certfile;
	std::string keyfile;
	SSL_CTX *ssl_ctx;
	bool setSSLInfo(std::string certfile,std::string keyfile);
	std::string getCertfile();
	std::string getKeyfile();
#endif
private:
	bool loadApiRedirect(KRedirect *rd,KApiPipeStream *st,int workType);
#ifdef ENABLE_VH_RUN_AS
#ifdef _WIN32
	HANDLE token;
	bool logoned;
	bool logonresult;
#endif
#endif
public:
#ifdef ENABLE_USER_ACCESS
	bool loadAccess(KVirtualHost *vh=NULL);
	time_t lastModified;
	time_t lastLoad;
#endif
};


#endif /*KVIRTUALHOST_H_*/
