/*
 * KMultiAcserver.cpp
 *
 *  Created on: 2010-6-4
 *      Author: keengo
 * Copyright (c) 2010, NanChang BangTeng Inc
 * All Rights Reserved.
 *
 * You may use the Software for free for non-commercial use
 * under the License Restrictions.
 *
 * You may modify the source code(if being provieded) or interface
 * of the Software under the License Restrictions.
 *
 * You may use the Software for commercial use after purchasing the
 * commercial license.Moreover, according to the license you purchased
 * you may get specified term, manner and content of technical
 * support from NanChang BangTeng Inc
 *
 * See COPYING file for detail.
 */
#include <sstream>
#include "KMultiAcserver.h"
#include "global.h"
#include "lang.h"
#include "malloc_debug.h"
#include "KAsyncFetchObject.h"
using namespace std;
#ifdef ENABLE_MULTI_SERVER
KMultiAcserver::KMultiAcserver() {
	nodes = NULL;
	nodesCount = 0;
	ip_hash = false;
	cookie_stick = false;
	errorTryTime = 20;
	max_error_count = 5;
}
KMultiAcserver::~KMultiAcserver() {
	removeAllNode();
}
void KMultiAcserver::removeAllNode()
{
	KSockPoolHelper *helper = nodes;
	while (helper) {
		KSockPoolHelper *n = helper->next;
		helper->release();
		nodesCount--;
		if (n==nodes) {
			break;
		}
		helper = n;
	}
	nodes = NULL;
	bnodes.clear();
	vnodes.clear();
	assert(nodesCount==0);
	nodesCount = 0;
}
void KMultiAcserver::enableAllServer()
{
	KSockPoolHelper *helper = nodes;
	while (helper) {
		KSockPoolHelper *n = helper->next;
		helper->enable();
		if (n==nodes) {
			break;
		}
		helper = n;
	}
}
int KMultiAcserver::getCookieStick(const char *attr,const char *cookie_stick_name)
{
	char *buf = strdup(attr);
	if (buf==NULL) {
		return -1;
	}
	int cookie_stick_value = -1;
	char *hot = buf;
	while (*hot) {
		char *p = strchr(hot,';');
		if (p) {
			*p = '\0';
		}
		while (*hot && isspace((unsigned char)*hot)) {
			hot ++;
		}
		char *eq = strchr(hot,'=');
		if (eq) {
			*eq = '\0';
			if (strcmp(hot,cookie_stick_name)==0) {
				cookie_stick_value = atoi(eq+1)-1;
				break;
			}
		}
		if (p==NULL) {
			break;
		}
		hot = p + 1;
	}
	free(buf);
	return cookie_stick_value;
}
unsigned short KMultiAcserver::getNodeIndex(KHttpRequest *rq)
{
	if (cookie_stick) {
		const char *cookie_stick_name = conf.cookie_stick_name;
		if (*cookie_stick_name=='\0') {
			cookie_stick_name = DEFAULT_COOKIE_STICK_NAME;
		}
		KHttpHeader *av = rq->parser.getHeaders();
		while (av) {
			if (strcasecmp(av->attr,"Cookie")==0) {
				int cookie_stick_value = getCookieStick(av->val,cookie_stick_name);
				if (cookie_stick_value>=0) {
					if (cookie_stick_value < (int)vnodes.size()) {
						return (unsigned short)cookie_stick_value;
					}
					break;
				}
			}
			av = av->next;
		}
	}
	unsigned short index = (unsigned short)((ip_hash?rq->server->addr.get_hash():rand()) % vnodes.size());
	if (cookie_stick) {
		rq->cookie_stick = index + 1;
	}
	return index;
}
void KMultiAcserver::connect(KHttpRequest *rq)
{
	if (vnodes.size() <= 0) {
		static_cast<KAsyncFetchObject *>(rq->fetchObj)->connectCallBack(rq,NULL);
		return;
	}
	unsigned short index = getNodeIndex(rq);
	KSockPoolHelper *sockHelper;
	lock.Lock();
	sockHelper = vnodes[index];
	if (errorTryTime==0 
		|| TEST(rq->filter_flags,RF_MSERVER_NOSWITCH) 
		|| sockHelper->isEnable()) {
		//the node is active
		sockHelper->addRef();
		sockHelper->hit++;
		lock.Unlock();
		sockHelper->connect(rq);
		sockHelper->release();
		return;
	}
	//look for next active node
	KSockPoolHelper *na = nextActiveNode(sockHelper,index);
	if (na) {
		if (cookie_stick) {
			//ճ·
			rq->cookie_stick = index + 1;
		}
		na->addRef();
		na->hit++;
		lock.Unlock();
		na->connect(rq);
		na->release();
		return;	
	}
	for (size_t i=0;i<bnodes.size();i++) {
		//look for backup node
		KSockPoolHelper *bnode = bnodes[i];
		if (errorTryTime==0 
			|| TEST(rq->filter_flags,RF_MSERVER_NOSWITCH) 
			|| bnode->isEnable()) {
			bnode->addRef();
			bnode->hit++;
			lock.Unlock();
			bnode->connect(rq);
			bnode->release();
			return;
		}
	}
	//reset all node
	enableAllServer();
	sockHelper->addRef();
	sockHelper->hit++;
	lock.Unlock();
	sockHelper->connect(rq);
	sockHelper->release();
	return;
}
KSockPoolHelper *KMultiAcserver::nextActiveNode(KSockPoolHelper *node,unsigned short &index)
{
	KSockPoolHelper *helper = node;
	bool use_next = (index & 1)>0;
	while (helper) {
		KSockPoolHelper *n = (use_next)?helper->next:helper->prev;
		if (use_next) {
			if (index>=vnodes.size()-1) {
				index = 0;
			} else {
				index ++;
			}
		} else {
			if (index==0) {
				index = vnodes.size() - 1;
			} else {
				index --;
			}
		}
		if (helper->tryTime==0) {
			return helper;
		}
		if (n==node) {
			return NULL;
		}
		helper = n;
	}
	return NULL;
}

unsigned KMultiAcserver::getPoolSize() {
	return 0;
}
bool KMultiAcserver::editNode(std::map<std::string,std::string> &attr) {
	string action = attr["action"];
	if (action=="edit") {
		int id = atoi(attr["id"].c_str());
		lock.Lock();
		KSockPoolHelper *node = getIndexNode(id);
		if (node) {
			node->weight = atoi(attr["weight"].c_str());
			node->parse(attr);
			buildVNode();
		}
		lock.Unlock();
	} else {
		KSockPoolHelper *sockHelper = new KSockPoolHelper;	
		if(!sockHelper->parse(attr)){
			delete sockHelper;
			return false;
		}
		unsigned weight = atoi(attr["weight"].c_str());
		sockHelper->weight = weight;
		sockHelper->error_try_time = errorTryTime;
		sockHelper->max_error_count = max_error_count;
		lock.Lock();
		addNode(sockHelper);
		buildVNode();
		lock.Unlock();
	}
	return true;
}
void KMultiAcserver::addNode(KSockPoolHelper *sockHelper)
{
	if (nodes==NULL) {
		sockHelper->next = sockHelper;
		sockHelper->prev = sockHelper;
		nodes = sockHelper;
	} else {
		sockHelper->next = nodes;
		sockHelper->prev = nodes->prev;
		nodes->prev->next = sockHelper;
		nodes->prev = sockHelper;
	}
	nodesCount++;
}
std::string KMultiAcserver::nodeForm(std::string name, KMultiAcserver *as,
		unsigned nodeIndex) {

	KSockPoolHelper *helper = NULL;
	if (as) {
		as->lock.Lock();
		helper = as->getIndexNode((int)nodeIndex);
	}
	stringstream s;
	s << "<form action='/macserver_node?name=" << name << "&action=";
	if (helper) {
		s << "edit";
	} else {
		s << "add";
	}
	s << "&id=" << nodeIndex << "' method='post'>\n";
	s << klang["lang_host"] << ": <input name='host' value='";
	if (helper) {
		if (helper->isUnix) {
			s << "unix:";
		}
		s << helper->host;
	}
	s  << "'>";
	s << LANG_PORT << ": <input name='port' size='5' value='" << (helper ? helper->port:80) ;
/////////[332]
	s << "'>";
	s << "<br>";
	s << klang["lang_life_time"] << ": <input name='life_time' size=6 value='"	<< (helper ? helper->getLifeTime() : 0) << "'><br>";
/////////[333]
	s << klang["weight"] << ": <input name='weight' value='"
			<< (helper ? helper->weight : 1) << "'><br>";

	s << "<input type='submit' value='" << LANG_SUBMIT << "'>";
	s << "</form>";
	if (as) {
		as->lock.Unlock();
	}
	return s.str();
}
KSockPoolHelper *KMultiAcserver::getIndexNode(int index)
{
	if(index>=nodesCount){
		return NULL;
	}
	KSockPoolHelper *helper = nodes;
	while (helper) {
		if (index--<=0) {
			return helper;
		}	
		KSockPoolHelper *n = helper->next;
		helper = n;
	}
	return NULL;
}
void KMultiAcserver::getNodeInfo(std::stringstream &s)
{
	lock.Lock();
	KSockPoolHelper *node = nodes;
	for (int i = 0; i < nodesCount; i++) {
		if (i>0) {
			s << "\n";
		}
		s << node->host;
		if (!node->isUnix) {
			s << ":" << node->port;
		}
		s << "\t" << node->hit << "\t" << (node->isEnable()?"OK":"FAILED");
		node = node->next;
	}
	lock.Unlock();
}
void KMultiAcserver::getHtml(std::stringstream &s) {
	lock.Lock();
	s << "<tr><td rowspan='" << nodesCount << "'>";
	s << "[<a href=\"javascript:if(confirm('really delete')){ window.location='/del_macserver?name="
			<< name << "';}\">" << LANG_DELETE << "</a>]";
	s << "[<a href='/extends?item=1&name=" << name << "'>";
	s << LANG_EDIT << "</a>]";
	s << "[<a href='/macserver_node_form?name=" << name << "&action=add'>"
			<< klang["add_node"] << "</a>]</td>";
	s << "<td rowspan='" << nodesCount << "'>" << name << "</td>";
	s << "<td rowspan='" << nodesCount << "'>";
	s << KPoolableRedirect::buildProto(proto);
	s << "</td>";
	s << "<td rowspan='" << nodesCount << "'>" << (ip_hash?LANG_ON:"&nbsp;") << "</td>";
	s << "<td rowspan='" << nodesCount << "'>" << (cookie_stick?LANG_ON:"&nbsp;") << "</td>";
	s << "<td rowspan='" << nodesCount << "'>" << errorTryTime << "</td>";
	s << "<td rowspan='" << nodesCount << "'>" << max_error_count << "</td>";
	s << "<td rowspan='" << nodesCount << "'>" << getRefFast()
			<< "</td>";
	KSockPoolHelper *node = nodes;
	for (int i = 0; i < nodesCount; i++) {
		assert(node);
		if (i > 0) {
			s << "<tr>";
		}
		s
				<< "<td>[<a href=\"javascript:if(confirm('delete this node?')){ window.location='/macserver_node?name="
				<< name << "&id=" << i << "&action=delete';}\">" << LANG_DELETE
				<< "</a>]";
		s << "[<a href='/macserver_node_form?name=" << name << "&id=" << i
				<< "&action=edit'>" << LANG_EDIT << "</a>]"
				<< (node->isUnix?"unix:":"") << node->host << "</td>";
		s << "<td>" ;
		if(node->isUnix)
			s << "-";
		else 
			s << node->port ;
		/////////[334]
		s << "</td>";
		s << "<td>" << node->getLifeTime() << "</td>";
		s << "<td>" << node->getSize() << "</td>";
		s << "<td>" << node->weight << "</td>";
		s << "<td>" << node->hit << "</td>";
		s << "<td>" << (node->isEnable()?"<font color=green>OK</font>":"<font color=red>FAILED</font>") << "</td>";
		s << "</tr>\n";
		node = node->next;
	}
	if (nodesCount == 0) {
		s << "<td colspan=7>&nbsp; </td></tr>";
	}
	lock.Unlock();
}
void KMultiAcserver::baseHtml(KMultiAcserver *mserver,std::stringstream &s)
{
#ifndef HTTP_PROXY
	s << klang["protocol"] << ":";
	s << "<input type='radio' name='proto' value='http' ";
	if (mserver==NULL || mserver->proto==Proto_http) {
		s << "checked";
	}
	s << ">http <input type='radio' name='proto' value='fastcgi' ";
	if(mserver && mserver->proto==Proto_fcgi){
		s << "checked";
	}
	s << ">fastcgi ";
	s << "<input type='radio' value='ajp' name='proto' ";
	if(mserver && mserver->proto==Proto_ajp){
		s << "checked";
	}
	s << ">ajp";
	s << "<input type='radio' value='uwsgi' name='proto' ";
	if(mserver && mserver->proto==Proto_uwsgi){
		s << "checked";
	}
	s << ">uwsgi";
	s << "<input type='radio' value='scgi' name='proto' ";
		if(mserver && mserver->proto==Proto_scgi){
		s << "checked";
	}
	s << ">scgi";
	s << "<input type='radio' value='hmux' name='proto' ";
	if(mserver && mserver->proto==Proto_hmux){
		s << "checked";
	}
	s << ">hmux";
	s << "<br>";
#endif
	s << "<input type='checkbox' name='ip_hash' value='1' ";
	if (mserver && mserver->ip_hash) {
		s << "checked";
	}
	s << ">" << klang["ip_hash"] << "<br>";
	s << "<input type='checkbox' name='cookie_stick' value='1' ";
	if (mserver && mserver->cookie_stick) {
		s << "checked";
	}
	s << ">" << klang["cookie_stick"] << "<br>";
	s << klang["error_try_time"] << "<input name='error_try_time' value='" << (mserver?mserver->errorTryTime:30) << "' size='4'><br>";
	s << klang["error_count"] << "<input name='max_error_count' value='" << (mserver?mserver->max_error_count:5) << "' size='4'><br>";

}
std::string KMultiAcserver::form(KMultiAcserver *mserver)
{
	std::stringstream s;
	s << "<form action='/macserveradd?action=" << (mserver?"edit":"add") << "' method=post>\n";
	s << LANG_NAME << ":<input name=name value='";
	if (mserver) {
		s << mserver->name;
	}
	s << "' ";
	if (mserver) {
		s << "readonly";
	}
	s << "><br>";
	baseHtml(mserver,s);
	s << "<input type=submit value=" << LANG_ADD << "></form>\n";
	return s.str();
}
void KMultiAcserver::parseNode(const char *nodeString)
{
	char *buf = strdup(nodeString);
	lock.Lock();
	removeAllNode();
	char *hot = buf;
	while (*hot) {
		char *p = strchr(hot,',');
		if (p) {
			*p = '\0';
		}
		char *port = NULL;
		if (*hot=='[') {
			hot ++;
			port = strchr(hot,']');
			if (port) {
				*port = '\0';
				port++;
				port = strchr(port,':');
				if (port) {
					port++;
				}
			}
		} else {
			port = strchr(hot,':');
		}
		if (port) {
			*port = '\0';
			port ++;
			char *lifeTime = strchr(port,':');
			if (lifeTime) {
				*lifeTime='\0';
				lifeTime++;
				char *weight = strchr(lifeTime,':');
				if (weight) {
					*weight = '\0';
					weight ++;
					KSockPoolHelper *sockHelper = new KSockPoolHelper;
					sockHelper->setHostPort(hot,port);
					sockHelper->setLifeTime(atoi(lifeTime));
					sockHelper->weight = atoi(weight);
					addNode(sockHelper);
				}
			}
		}
		if (p==NULL) {
			break;
		}
		hot = p+1;
	}
	buildVNode();
	lock.Unlock();
	free(buf);
}
void KMultiAcserver::parse(std::map<std::string,std::string> &attribute)
{
	lock.Lock();
	if (name.size()==0) {
		name = attribute["name"];
	}
	ip_hash = attribute["ip_hash"]=="1";
	cookie_stick = attribute["cookie_stick"]=="1";
	proto = KPoolableRedirect::parseProto(attribute["proto"].c_str());
	errorTryTime = atoi(attribute["error_try_time"].c_str());
	max_error_count = atoi(attribute["max_error_count"].c_str());
	KSockPoolHelper *helper = nodes;
	while (helper) {
		KSockPoolHelper *n = helper->next;
		helper->error_try_time = errorTryTime;
		helper->max_error_count = max_error_count;
		if (n==nodes) {
			break;
		}
		helper = n;
	}
	lock.Unlock();
}
bool KMultiAcserver::delNode(int nodeIndex) {
	bool result = false;
	lock.Lock();
	KSockPoolHelper *helper = nodes;
	while (helper) {
		if (nodeIndex--<=0) {
			break;
		}	
		KSockPoolHelper *n = helper->next;
		helper = n;
	}
	if (helper) {
		nodesCount--;
		if (helper==nodes) {
			nodes=nodes->next;
		}
		if (helper==helper->next) {
			assert(nodesCount==0);
			nodes = NULL;
		} else {
			helper->prev->next = helper->next;
			helper->next->prev = helper->prev;
		}
		helper->release();
		buildVNode();
	}
	lock.Unlock();
	return result;
}
void KMultiAcserver::buildVNode()
{
	vnodes.clear();
	bnodes.clear();
	KSockPoolHelper *helper = nodes;
	while (helper) {
		KSockPoolHelper *n = helper->next;
		if (helper->weight==0) {
			bnodes.push_back(helper);
		} else {
			for (int i=0;i<helper->weight;i++) {
				vnodes.push_back(helper);
			}
		}
		if (n==nodes) {
			break;
		}
		helper = n;
	}
}
void KMultiAcserver::buildAttribute(std::stringstream &s)
{
	s << "proto='";
	s << KPoolableRedirect::buildProto(proto);
	s << "' ip_hash='" << (ip_hash?1:0) << "' ";
	s << "cookie_stick='" << (cookie_stick?1:0) << "' ";
	s << "error_try_time='" << errorTryTime << "' ";
	s << "max_error_count='" << max_error_count << "'";
}
void KMultiAcserver::buildXML(std::stringstream &s) {
	s << "\t<server name='" << name << "' ";
	buildAttribute(s);
	s << ">\n";
	lock.Lock();
	KSockPoolHelper *helper = nodes;
	while (helper) {
		KSockPoolHelper *n = helper->next;
		s << "\t\t<node  weight='" << helper->weight << "'";
		helper->buildXML(s);
		s << "/>\n";
		if (n==nodes) {
			break;
		}
		helper = n;
	}
	lock.Unlock();
	s << "\t</server>\n";
}
bool KMultiAcserver::isChanged(KPoolableRedirect *rd)
{
	KMultiAcserver *ma = static_cast<KMultiAcserver *>(rd);
	if (this->nodesCount!=ma->nodesCount) {
		return true;
	}
	KSockPoolHelper *helper = nodes;
	KSockPoolHelper *maHelper = ma->nodes;
	while (helper) {
		assert(maHelper);
		if (helper->isChanged(maHelper)) {
			return true;
		}
		helper = helper->next;
		maHelper = maHelper->next;
		if (helper==nodes) {
			break;
		}
	}
	return false;
}
#endif
