/*
 * KISAPIServiceProvider.h
 *
 *  Created on: 2010-8-7
 *      Author: keengo
 */

#ifndef KISAPISERVICEPROVIDER_H_
#define KISAPISERVICEPROVIDER_H_
#include <sstream>
#include <vector>
#include "KApiFetchObject.h"
#include "KServiceProvider.h"
#include "httpext.h"
#include "KHttpKeyValue.h"

#include "KStream.h"
#include "KString.h"

class KISAPIServiceProvider: public KServiceProvider, public KStream {
public:
	KISAPIServiceProvider();
	virtual ~KISAPIServiceProvider();
	Token_t getToken() {
		Token_t token;
		if (pECB->ServerSupportFunction(pECB->ConnID,
				HSE_REQ_GET_IMPERSONATION_TOKEN, (LPVOID) &token, NULL, NULL)
				== TRUE) {
			return token;
		}
		return NULL;
	}
	KWStream *getOutputStream() {
		return this;
	}
	KRStream *getInputStream() {
		return this;
	}
	bool execUrl(const char *url);
	void log(const char *str);
	int read(char *buf, int len);
	int write(const char *buf, int len);
	StreamState write_end();
	char getMethod() {
		if (meth != METH_UNSET) {
			return meth;
		}
		meth = KHttpKeyValue::getMethod(pECB->lpszMethod);
		return meth;
	}
	const char *getRemoteAddr() {
		return NULL;
	}
	int getRemotePort() {
		return 0;
	}
	const char *getFileName() {
		return pECB->lpszPathTranslated;
	}
	const char *getDocumentRoot() {
		return NULL;
	}
	const char *getQueryString() {
		return pECB->lpszQueryString;
	}
	const char *getRequestUri() {
		return pECB->lpszPathInfo;
	}
	unsigned getContentLength() {
		return pECB->cbTotalBytes;
	}
	const char *getContentType() {
		return pECB->lpszContentType;
	}
	char *getPreLoadedBody(int *len) {
		*len = pECB->cbAvailable;		
		pECB->cbAvailable = 0;
		return (char *) pECB->lpbData;
	}
	char *getHttpHeader(const char *attr) {
		std::stringstream s;
		s << "HTTP_";
		while (*attr) {
			if (*attr == '-') {
				s << "_";
			} else {
				s << (char) toupper(*attr);
			}
			attr++;
		}
		int len = sizeof(header_val);
		if (getEnv(s.str().c_str(), header_val, &len)) {
			return header_val;
		}
		return NULL;
	}
	bool isHeadSend() {
		return headSended;
	}
	bool sendKnowHeader(int attr, const char *val) {
		return true;
	}
	bool sendUnknowHeader(const char *attr, const char *val);
	bool sendStatus(int statusCode, const char *statusLine);
	bool getEnv(const char *attr, char *val, int *len);

	//bool getServerVar(const char *name, char *value, int len);
	void setECB(EXTENSION_CONTROL_BLOCK *pECB) {
		this->pECB = pECB;
	}
private:
	char header_val[512];
	void checkHeaderSend();
	char meth;
	char *remoteAddr;
	int remote_port;
	char *docRoot;
	bool headSended;
	EXTENSION_CONTROL_BLOCK *pECB;
	KStringBuf s;
	KStringBuf status;
};

#endif /* KISAPISERVICEPROVIDER_H_ */
