#ifndef KHTTPOBJECT_H_
#define KHTTPOBJECT_H_

#include "KMutex.h"

#include "forwin32.h"
#include "KBuffer.h"
#include "log.h"
#include "KHttpKeyValue.h"
#include "KDiskCache.h"
#include "KUrl.h"
#include "KHttpHeader.h"
#include "KHttpRequest.h"
/////////[47]
#include "time_utils.h"
#include "KFile.h"
#include "KBuffer.h"

#define   LIST_IN_MEM   0
#define   LIST_IN_DISK  1
#define   LIST_IN_NONE  2

extern KMutex hash_lock[HASH_SIZE+1];

class KHttpObjectHash;

#define MEMORY_OBJECT       0
#define BIG_OBJECT          1
#define BIG_OBJECT_PROGRESS 2
#define SWAPING_OBJECT      3
/**
 * httpobjectϢ
 */
class KHttpObjectBody {
public:
	KHttpObjectBody() {
		memset(this, 0, sizeof(KHttpObjectBody));
	}
	KHttpObjectBody(KHttpObjectBody *data);
	~KHttpObjectBody() {
		if (headers) {
			free_header(headers);
		}
		switch(type){
		case MEMORY_OBJECT:
			if (bodys) {
				KBuffer::destroy(bodys);
			}
			break;
		case SWAPING_OBJECT:
			if (os) {
				delete os;
			}
			break;
		/////////[48]
		}
	}
	unsigned short status_code;
	unsigned short type;
	int headerSize;
	KHttpHeader *headers; /* headers */
	union {
		buff *bodys; /* data storage	*/
		KHttpObjectSwaping *os;
		/////////[49]
	};
};
/**
 * httpҳ֮,
 */
class KHttpObject {
public:
	KHttpObject() {
		init(NULL);
	}
	KHttpObject(KHttpRequest *rq) {		
		init(rq->url);
		data = new KHttpObjectBody();	
		SET(index.flags,FLAG_IN_MEM);
	}
	KHttpObject(KHttpObject *obj);
	void init(KUrl *url) {
		memset(&index,0,sizeof(index));
		list_state = LIST_IN_NONE;
		in_cache = 0;
		index.last_verified = kgl_current_sec;
		this->url = url;
		h = HASH_SIZE;
		refs = 1;
		data = NULL;
	}
	inline char *getCharset()
	{
		if(data==NULL){
			return NULL;
		}
		KHttpHeader *tmp = data->headers;
		while(tmp){
			if(strcasecmp(tmp->attr,"Content-Type")==0){		
				const char *p = strstr(tmp->val, "charset=");
				if (p) {
					p += 8;
					while (*p && IS_SPACE((unsigned char)*p))
						p++;
					const char *charsetend = p;
					while (*charsetend && !IS_SPACE((unsigned char)*charsetend)
							&& *charsetend != ';')
						charsetend++;
					int charset_len = charsetend - p;
					char *charset = (char *)malloc(charset_len+1);
					memcpy(charset,p,charset_len);
					charset[charset_len] = '\0';
					return charset;		
				}
				return NULL;
			}
			tmp = tmp->next;
		}
		return NULL;
	}
	KMutex *getLock()
	{
		return &hash_lock[h];
	}
	int getRefs() {
		u_short hh = h;
		hash_lock[hh].Lock();
		int ret = refs;
		hash_lock[hh].Unlock();
		return ret;
	}
	void addRef() {
		u_short hh = h;
		hash_lock[hh].Lock();
		refs++;
		hash_lock[hh].Unlock();
	}
	void release()
	{
		u_short hh = h;
		hash_lock[hh].Lock();
		assert(refs>0);
		refs--;
		if (refs==0) {
			hash_lock[hh].Unlock();
			delete this;
			return;
		}
		hash_lock[hh].Unlock();
	}
	unsigned getCurrentAge(time_t nowTime) {	
		return (unsigned) (nowTime - index.last_verified);
	}
#ifdef ENABLE_FORCE_CACHE
	//ǿƻ
	void forceCache(bool insertLastModified=true)
	{
		CLR(index.flags,ANSW_NO_CACHE|OBJ_MUST_REVALIDATE);
		if (!TEST(index.flags,ANSW_LAST_MODIFIED)) {
			index.last_modified = kgl_current_sec;
			if (insertLastModified) {
				char *tmp_buf = (char *)malloc(41);
				memset(tmp_buf, 0, 41);
				mk1123time(index.last_modified, tmp_buf, 41);
				insertHttpHeader2(strdup("Last-Modified"),tmp_buf);
			}
		}
		SET(index.flags,OBJ_IS_STATIC2|ANSW_LAST_MODIFIED|FLAG_NEED_CACHE);
	}
#endif
	bool checkNobody() {
		if ((data->status_code >= 100
				&& data->status_code < 200) || data->status_code
				== STATUS_NOT_MODIFIED || data->status_code == 204) {
			//no content,see rfc2616.
			SET(index.flags,FLAG_NO_BODY);
			return true;
		}
		if (TEST(index.flags,ANSW_XSENDFILE)) {
			SET(index.flags,FLAG_NO_BODY);
			return true;
		}
		return false;
	}
	void unlinkDiskFile();
	bool swapin(KHttpObjectBody *data);
	bool swapinBody(KFile *fp,KHttpObjectBody *data);
	void count_size(INT64 &mem_size,INT64 &disk_size)
	{
		if (TEST(index.flags,FLAG_IN_MEM)) {
		/////////[50]
				mem_size += index.have_length;
		}
		if (TEST(index.flags,FLAG_IN_DISK)) {
			disk_size += index.have_length;
		}
	}
	bool swapout();
#ifdef ENABLE_DISK_CACHE
	char *getFileName(bool part=false);
#endif
	int saveHead(KFile *fp);
	int saveIndex(KFile *fp);

	bool removeHttpHeader(const char *attr)
	{
		bool result = false;
		KHttpHeader *h = data->headers;
		KHttpHeader *last = NULL;
		while (h) {
			KHttpHeader *next = h->next;
			if (strcasecmp(h->attr,attr)==0) {
				if (last) {
					last->next = next;
				} else {
					data->headers = next;
				}
				free(h->attr);
				free(h->val);
				free(h);
				h = next;
				result = true;
				continue;
			}
			last = h;
			h = next;
		}
		return result;
	}
	void insertHttpHeader2(char *attr,char *val)
	{
		KHttpHeader *new_h = (KHttpHeader *) xmalloc(sizeof(KHttpHeader));
		new_h->attr = attr;
		new_h->val = val;
		new_h->next = data->headers;
		data->headers = new_h;
	}
	void insertHttpHeader(const char *attr, const char *val) {
		insertHttpHeader2(xstrdup(attr),xstrdup(val));
	}
	INT64 getTotalContentSize(KHttpRequest *rq)
	{
		if (TEST(index.flags,ANSW_HAS_CONTENT_RANGE)) {
			return rq->ctx->content_range_length;
		}
		return index.content_length;
	}
	KHttpObject *lnext; /* in list */
	KHttpObject *lprev; /* in list */
	KHttpObject *next;  /* in hash */	
	/* list state
	 LIST_IN_NONE
	 LIST_IN_MEM
	 LIST_IN_DISK
	 */
	unsigned char list_state;
	unsigned char in_cache;
	short h; /* hash value */
	int refs;	
	KUrl *url;
	KHttpObjectBody *data;
	HttpObjectIndex index;
private:
	~KHttpObject();
};
#endif /*KHTTPOBJECT_H_*/
