/*
 * KFetchObject.h
 *
 *  Created on: 2010-4-19
 *      Author: keengo
 * Copyright (c) 2010, NanChang BangTeng Inc
 * All Rights Reserved.
 *
 * You may use the Software for free for non-commercial use
 * under the License Restrictions.
 *
 * You may modify the source code(if being provieded) or interface
 * of the Software under the License Restrictions.
 *
 * You may use the Software for commercial use after purchasing the
 * commercial license.Moreover, according to the license you purchased
 * you may get specified term, manner and content of technical
 * support from NanChang BangTeng Inc
 *
 * See COPYING file for detail.
 */

#ifndef KFETCHOBJECT_H_
#define KFETCHOBJECT_H_
#include <time.h>
#include "KHttpRequest.h"
#include "KBuffer.h"
#include "KPathRedirect.h"
#define READ_SWITCH_FUNCTION	-3
#define READ_PROTOCOL_ERROR		-2


#define SEND_HEAD_FAILED		0
#define SEND_HEAD_SUCCESS		1
#define SEND_HEAD_PULL_MODEL	2
//#define SEND_HEAD_ASYNC_MODEL   3
#define SEND_HEAD_SYNC_MODEL    4
#define SEND_HEAD_ERROR         5
#ifdef ENABLE_REQUEST_QUEUE
class KRequestQueue;
#endif
class KHttpObject;
class KHttpRequest;
class buff;
class KContext;
/**
Դ(̬ݣ̬ݣ⣬ݾԴԴ)
ԴĻ
*/
class KFetchObject {
public:
	KFetchObject()
	{
		brd = NULL;
		closed = true;
	}
	virtual ~KFetchObject()
	{
		if (brd) {
			brd->release();
		}
	}
	/*
	 * Դ,
	 */
	virtual void open(KHttpRequest *rq)
	{
		this->closed = false;
	}
	//Դbody
	virtual void readBody(KHttpRequest *rq)
	{
	}
	//֪ͨbody
	virtual void readBodyEnd(KHttpRequest *rq)
	{
	}
	/*
	 *Ƿͬ
	*/
	virtual bool isSync()
	{
		return false;
	}
	//رԴ
	virtual void close(KHttpRequest *rq)
	{
		this->closed = true;
	}
	bool isClosed()
	{
		return closed;
	}
	void bindBaseRedirect(KBaseRedirect *brd)
	{
		kassert(this->brd==NULL);
		this->brd = brd;
		if (brd) {
			brd->addRef();
		}
	}
	KBaseRedirect *getBaseRedirect()
	{
		return brd;
	}
	virtual KFetchObject *clone(KHttpRequest *rq);
#ifdef ENABLE_REQUEST_QUEUE
	//ԴǷҪйܡڱݲøùܡ
	//ݺͶ̬򷵻true
	virtual bool needQueue()
	{
		return false;
	}
#endif
protected:
	void setClosed(bool closed)
	{
		this->closed = closed;
	}
	KBaseRedirect *brd;
	/*
	Ѿupstreamݣtrue,ȡfalse򲻼ʾѾݿԷrq
	*/
	bool pushHttpBody(KHttpRequest *rq,char *buf,int len);
	bool closed;
};

#endif /* KFETCHOBJECT_H_ */
