#include "KDynamicListen.h"
#include "KVirtualHost.h"
#include "KSocket.h"
#include "KServerListen.h"
#include "KVirtualHostManage.h"
#include "KSelectorManager.h"
#include "lib.h"
#define DEFAULT_IPV4_IP  "0.0.0.0"
#define DEFAULT_IPV6_IP  "::"
KDynamicListen dlisten;
void KDynamicListen::add(const char *listen,KVirtualHost *vh)
{
	std::list<KListenKey> lk;
	parseListen(listen,lk);
	if (lk.size()<=0) {
		return;
	}	
	std::map<KListenKey,KServer *>::iterator it;
	std::list<KListenKey>::iterator it2;
	for (it2=lk.begin();it2!=lk.end();it2++) {
		KServer *server = NULL;
		//lock.Lock();
		it = listens.find((*it2));
		if (it==listens.end()) {
			server = new KServer;
			server->model = 0;
#ifdef SSL_CTRL_SET_TLSEXT_HOSTNAME
			if ((*it2).ssl) {
				server->certificate = vh->getCertfile();
				server->certificate_key = vh->getKeyfile();
				server->sslParsed = true;
				server->sni = true;
				SET(server->model,WORK_MODEL_SSL);
			}
#endif
			server->dynamic = true;
			listens.insert(std::pair<KListenKey,KServer *>((*it2),server));
			initListen((*it2),server);
		} else {
			server = (*it).second;
#ifdef SSL_CTRL_SET_TLSEXT_HOSTNAME
			if (!server->isOpened() && (*it2).ssl && server->dynamic) {
				//update ssl certificate and try it again.
				server->certificate = vh->getCertfile();
				server->certificate_key = vh->getKeyfile();
				server->sslParsed = true;
				server->sni = true;
				SET(server->model,WORK_MODEL_SSL);
				initListen((*it2),server);
			}
#endif
		}
		server->bindVirtualHost(vh);
	}
}
void KDynamicListen::remove(const char *listen,KVirtualHost *vh)
{
	std::list<KListenKey> lk;
	parseListen(listen,lk);
	if (lk.size()<=0) {
		return;
	}	
	std::map<KListenKey,KServer *>::iterator it;
	std::list<KListenKey>::iterator it2;
	for (it2=lk.begin();it2!=lk.end();it2++) {
		it = listens.find((*it2));
		if (it!=listens.end()) {
			(*it).second->removeVirtualHost(vh);
		}
	}	
}
void KDynamicListen::flush()
{
	std::map<KListenKey,KServer *>::iterator it,it_next;
	for (it=listens.begin();it!=listens.end();) {
		KServer *server = (*it).second;
		it_next = it;
		it_next++;
		if (server->dynamic && server->isEmpty()) {
#ifdef _WIN32
			server->close();
#else
			server->setClosed();
			server->server.shutdown(SHUT_RDWR);
#endif
			listens.erase(it);
			server->release();
		}
		it = it_next;
	}
}
void KDynamicListen::flush(const char *listen)
{
	std::list<KListenKey> lk;
	parseListen(listen,lk);
	if (lk.size()<=0) {
		return;
	}
	std::map<KListenKey,KServer *>::iterator it;
	std::list<KListenKey>::iterator it2;
	for (it2=lk.begin();it2!=lk.end();it2++) {
		std::map<KListenKey,KServer *>::iterator it = listens.find((*it2));
		if (it!=listens.end()) {
			KServer *server = (*it).second;
			if (server->dynamic && server->isEmpty()) {
#ifdef _WIN32
				server->close();
#else
				server->setClosed();
				server->server.shutdown(SHUT_RDWR);
#endif
				listens.erase(it);
				server->release();
			}
		}
	}
}

bool KDynamicListen::add(KListenHost *listen,bool start)
{
	std::list<KListenKey> lk;
	parseListen(listen,lk);
	if (lk.size()<=0) {
		return false;
	}	
	std::map<KListenKey,KServer *>::iterator it;
	std::list<KListenKey>::iterator it2;
	for (it2=lk.begin();it2!=lk.end();it2++) {
		KServer *server = NULL;
		it = listens.find((*it2));
		if (it==listens.end()) {
			server = new KServer;
			server->model = listen->model;
			server->name = listen->name;
			server->event_driven = listen->event_driven;
#ifdef KSOCKET_SSL
			if ((*it2).ssl) {
				server->certificate = listen->certificate;
				server->certificate_key = listen->certificate_key;
				server->sslParsed = true;
				server->sni = listen->sni;
			}
#endif
			listens.insert(std::pair<KListenKey,KServer *>((*it2),server));
			if (initListen((*it2),server)) {
				if (start) {
					conf.gvm->bindVirtualHost(server);
				}
			}
		} else {
			server = (*it).second;
			server->dynamic = false;
#ifdef KSOCKET_SSL
            if (!server->isOpened() && (*it2).ssl) {
                    //update ssl certificate and try it again.
                    server->certificate = listen->certificate;
                    server->certificate_key = listen->certificate_key;
                    server->sslParsed = true;
                    server->sni = listen->sni;
                    SET(server->model,WORK_MODEL_SSL);
                    initListen((*it2),server);
            }
#endif
		}
	}
	return true;
}
void KDynamicListen::parseListen(KListenHost *lh,std::list<KListenKey> &lk)
{
	if (strcmp(lh->ip.c_str(),"*")==0) {
		lk.push_back(getListenKey(lh,true));
	
#ifdef KSOCKET_IPV6
		lk.push_back(getListenKey(lh,false));
#endif
	} else {		
		bool ipv4 = true;
#ifdef KSOCKET_IPV6
		sockaddr_i addr;
		if (KSocket::getaddr(lh->ip.c_str(),0,&addr,0,AI_NUMERICHOST)) {
			if(PF_INET == addr.v4.sin_family){
				ipv4 = true;
			} else {
				ipv4 = false;
			}
		}

#endif
		lk.push_back(getListenKey(lh,ipv4));
	}
	return;
}
void KDynamicListen::parseListen(const char *listen,std::list<KListenKey> &lks)
{
	char *buf = strdup(listen);
	char *p = strrchr(buf,':');
	if (p) {
		*p = '\0';
		p++;
		KListenKey lk;
		lk.port = atoi(p);
		lk.ssl = false;
		if (strchr(p,'s')) {
			lk.ssl = true;
		}
		if (strcmp(buf,"*")==0) {
			lk.ip = DEFAULT_IPV4_IP;
			lk.ipv4 = true;
			lks.push_back(lk);
#ifdef KSOCKET_IPV6
			lk.ip = DEFAULT_IPV6_IP;
			lk.ipv4 = false;
			lks.push_back(lk);
#endif
		} else {
			sockaddr_i addr;
			lk.ip = buf;
#ifdef KSOCKET_IPV6
			if (KSocket::getaddr(buf,0,&addr,0,AI_NUMERICHOST)) {
				if(PF_INET == addr.v4.sin_family){
					lk.ipv4 = true;
				} else {
					lk.ipv4 = false;
				}
			}
#else
			lk.ipv4 = true;
#endif
			lks.push_back(lk);
		}
	}
	free(buf);	
}
bool KDynamicListen::initListen(const KListenKey &lk,KServer *server)
{
	int flag = (lk.ipv4?KSOCKET_ONLY_IPV4:KSOCKET_ONLY_IPV6);
#ifdef ENABLE_TPROXY
	if (TEST(server->model,WORK_MODEL_TPROXY)) {
		flag |= KSOCKET_TPROXY;
	}
#endif
	SAFE_STRCPY(server->ip,lk.ip.c_str());
	server->port = lk.port;
	bool result = false;
	for (;;) {
		result = server->server.open(lk.port,(lk.ip.size()>0?lk.ip.c_str():NULL),flag);
		if (result) {
			break;
		}
		server->server.close();
		if (failedTries>10) {
			break;
		}
		failedTries++;
		my_msleep(500);
	}
	if (!result) {
		klog(KLOG_ERR, "Cann't listen %s:%d[tcp%s] ,errno=%d\n",
			lk.ip.c_str(), lk.port,
			server->server.getIpVer(),	errno);
		return false;
	}
#ifdef KSOCKET_SSL
	if (TEST(server->model,WORK_MODEL_SSL)) {
		if (!server->load_ssl()) {
			server->server.close();
			return false;
		}
	}
#endif
	klog(KLOG_NOTICE, "listen %s:%d[tcp%s] success\n",
			lk.ip.c_str(), lk.port,
			server->server.getIpVer());
	if (selectorManager.isInit()) {
		KServerListen::start(server);
	}
	return result;
}
KListenKey KDynamicListen::getListenKey(KListenHost *lh,bool ipv4)
{
	KListenKey key;
	key.port = lh->port;
	key.ssl = TEST(lh->model,WORK_MODEL_SSL)>0;
	key.ipv4 = ipv4;
	if (lh->ip=="*") {
		if (ipv4) {
			key.ip = DEFAULT_IPV4_IP;
		} else {
			key.ip = DEFAULT_IPV6_IP;
		}
	} else {
		key.ip = lh->ip;
	}
	return key;
}
void KDynamicListen::delayStart()
{
	assert(selectorManager.isInit());
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		if (server->isOpened() && !server->started) {
			KServerListen::start(server);
		}
	}
}
void KDynamicListen::addStaticVirtualHost(KVirtualHost *vh)
{
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		if (server->isOpened() && !server->dynamic) {
			server->addVirtualHost(vh);
		}
	}
}
void KDynamicListen::removeStaticVirtualHost(KVirtualHost *vh)
{
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		if (server->isOpened() && !server->dynamic) {
			server->removeVirtualHost(vh);
		}
	}
}
void KDynamicListen::clear()
{
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		server->close();
		server->release();
	}
	listens.clear();
}
void KDynamicListen::close()
{
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		if (server->isOpened()) {
			server->close();
		}
	}
}
void KDynamicListen::getListenHtml(std::stringstream &s)
{
	std::map<KListenKey,KServer *>::iterator it;
	for (it=listens.begin();it!=listens.end();it++) {
		KServer *server = (*it).second;
		if (server->started){
			s << "<tr>";
			/*<td>[<a href=\"javascript:if(confirm('really stop')){ window.location='/stoplisten?id=";
			s << i << "';}\">" << klang["stop"] << "</a>]</td>";
			*/
			s << "<td>" << server->name << "</td>";
			s << "<td>" << server->ip << "</td>";
			s << "<td>" << server->server.get_self_port() << "</td>";
			s << "<td>" << getWorkModelName(server->model) << "</td>";
			s << "<td>tcp/ipv" << server->server.getIpVer() << "</td>";
			s << "<td>" << (server->dynamic?"yes":"&nbsp;");
			if (server->isEmpty()) {
				s << " E";
			}
			s << "</td>";
			s << "</tr>";
		}
	}
}
