/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.resources;

import com.aptana.ide.core.resources.Messages;
import com.aptana.ide.core.resources.UniformResourceStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class LocalFileStorage
extends UniformResourceStorage {
    private File file;

    public LocalFileStorage(File file) {
        this.file = file;
    }

    public URI getURI() {
        return this.getFile().toURI();
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.ide.core", 0, Messages.LocalFileStorage_ExceptionRetrievingFileContents, (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return Path.fromOSString((String)this.getFile().getAbsolutePath());
    }

    public String getName() {
        return this.getFile().getName();
    }

    public boolean isReadOnly() {
        return !this.getFile().canWrite();
    }

    public File getFile() {
        return this.file;
    }

    public Object getAdapter(Class adapter) {
        if (IPath.class == adapter) {
            return this.getFullPath();
        }
        return super.getAdapter(adapter);
    }
}

