/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.online;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.online.IOnlineStateChangedListener;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;

public class OnlineDetectionService {
    protected static final long SLEEP_DELAY = 30000L;
    private static final int URL_TIMEOUT = 10000;
    private static OnlineDetectionService INSTANCE = null;
    private List<URL> _detectionURLs = new ArrayList<URL>();
    private static ListenerList listeners = new ListenerList();
    private StatusMode _status = StatusMode.UNKNOWN;

    private OnlineDetectionService() {
        this.startDetectionThread();
    }

    public static OnlineDetectionService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OnlineDetectionService();
        }
        return INSTANCE;
    }

    public StatusMode getStatus() {
        return this._status;
    }

    public static void addListener(IOnlineStateChangedListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(IOnlineStateChangedListener listener) {
        listeners.remove((Object)listener);
    }

    public void addDetectionURL(URL url) {
        if (!this._detectionURLs.contains(url)) {
            this._detectionURLs.add(url);
            this.detectOnlineStatus();
        }
    }

    public void removeDetectionURL(URL url) {
        this._detectionURLs.remove(url);
    }

    private void detectOnlineStatus() {
        new Thread(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                StatusMode oldStatus = OnlineDetectionService.this._status;
                try {
                    if (OnlineDetectionService.this._detectionURLs.size() == 0) {
                        OnlineDetectionService.this._status = StatusMode.UNKNOWN;
                        return;
                    }
                    for (URL url : OnlineDetectionService.this._detectionURLs) {
                        if (OnlineDetectionService.this.isAvailable(url)) continue;
                        OnlineDetectionService.this._status = StatusMode.OFFLINE;
                        return;
                    }
                    OnlineDetectionService.this._status = StatusMode.ONLINE;
                    return;
                }
                finally {
                    if (oldStatus != OnlineDetectionService.this._status) {
                        OnlineDetectionService.this.notifyListeners(oldStatus);
                    }
                }
            }
        }, "DetectOnlineStatus URL Checker").run();
    }

    private void notifyListeners(final StatusMode oldStatus) {
        Object[] oListeners = listeners.getListeners();
        int i = 0;
        while (i < oListeners.length) {
            final IOnlineStateChangedListener listener = (IOnlineStateChangedListener)oListeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    IdeLog.logInfo(AptanaCorePlugin.getDefault(), "Error notifying message listener", exception);
                }

                public void run() throws Exception {
                    listener.stateChanged(oldStatus, OnlineDetectionService.this.getStatus());
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    private boolean isAvailable(URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setReadTimeout(10000);
            conn.connect();
            conn.getResponseCode();
            conn.disconnect();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
        }
        catch (Exception e) {
            IdeLog.logInfo(AptanaCorePlugin.getDefault(), "OnlineDetectionService: Checking for URL availability (" + url + "): " + e.getMessage());
            return false;
        }
        return true;
    }

    private void startDetectionThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        OnlineDetectionService.this.detectOnlineStatus();
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }, "Aptana: Online Detection Service");
        t.setDaemon(true);
        t.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusMode {
        UNKNOWN,
        ONLINE,
        OFFLINE;

    }
}

