/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model.user;

import com.aptana.ide.core.ILogger;
import com.aptana.ide.core.model.FieldModelObject;
import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IServiceErrors;
import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.ServiceErrors;
import com.aptana.ide.core.model.channel.Channel;
import com.aptana.ide.core.model.channel.ChannelType;
import com.aptana.ide.core.model.channel.Channels;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.Node;

public class User
extends FieldModelObject {
    public static final String USER = "user";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String ENCRYPTED_PASSWORD = "encryptedPassword";
    public static final String EMAIL = "email";
    public static final String FIRST_NAME = "first_name";
    public static final String LAST_NAME = "last_name";
    public static final String PHONE = "phone";
    public static final String IP_ADDRESS = "ip_address";
    public static final String ADDRESS1 = "address1";
    public static final String ADDRESS2 = "address2";
    public static final String CITY = "city";
    public static final String STATE = "state";
    public static final String ZIP = "zipcode";
    public static final String COUNTRY = "country";
    public static final String ROLE = "role";
    public static final String COMPANY = "company";
    public static final String ORG_SIZE = "organization_size";
    public static final String ORG_TYPE = "organization_type";
    public static final String SITES_PER_YEAR = "sites_per_year";
    public static final String AJAX = "ajax";
    public static final String JAVASCRIPT = "javascript";
    public static final String PHP = "php";
    public static final String RUBY = "ruby";
    public static final String JAVA = "java";
    public static final String PYTHON = "python";
    public static final String NET = "net";
    public static final String SITE_DEVELOPMENT = "site_development";
    public static final String APPLICATION_DEVELOPMENT = "application_development";
    public static final String NEWSLETTER = "newsletter";
    public static final String CAPTCHA_CHALLENGE = "captcha_token";
    public static final String CAPTCHA_RESPONSE = "captcha_response";
    protected Channels channels;

    public User(String username, String password, String email, String firstName, String lastName, String challenge, String response) {
        this.addField(USERNAME, null, username);
        this.addField(PASSWORD, null, password);
        this.addField(ENCRYPTED_PASSWORD, null, null);
        this.addField(EMAIL, null, email);
        this.addField(FIRST_NAME, null, firstName);
        this.addField(LAST_NAME, null, lastName);
        this.addField(PHONE, null, null);
        this.addField(IP_ADDRESS, null, null);
        this.addField(ADDRESS1, null, null);
        this.addField(ADDRESS2, null, null);
        this.addField(CITY, null, null);
        this.addField(STATE, null, null);
        this.addField(ZIP, null, null);
        this.addField(COUNTRY, null, null);
        this.addField(ROLE, null, null);
        this.addField(COMPANY, null, null);
        this.addField(ORG_SIZE, null, null);
        this.addField(ORG_TYPE, null, null);
        this.addField(SITES_PER_YEAR, null, null);
        this.addField(AJAX, null, null);
        this.addField(JAVASCRIPT, null, null);
        this.addField(PHP, null, null);
        this.addField(RUBY, null, null);
        this.addField(JAVA, null, null);
        this.addField(PYTHON, null, null);
        this.addField(CAPTCHA_CHALLENGE, null, challenge);
        this.addField(CAPTCHA_RESPONSE, null, response);
        this.channels = new Channels();
    }

    public User() {
        this(null, null, null, null, null, null, null);
    }

    public void addListener(IModelListener listener) {
        super.addListener(listener);
        this.channels.addListener(listener);
    }

    public void removeListener(IModelListener listener) {
        super.removeListener(listener);
        this.channels.removeListener(listener);
    }

    public IServiceErrors update() {
        IServiceErrors errors = super.update();
        if (this.hasLocation() && ((Channel[])this.channels.getItems()).length == 0) {
            this.channels.update();
        }
        return errors;
    }

    public boolean hasCredentials() {
        return this.getUsername() != null && this.getUsername().length() > 0 && this.getPassword() != null && this.getPassword().length() > 0;
    }

    public String getPassword() {
        return this.getField(PASSWORD);
    }

    public void setPassword(String password) {
        this.setField(PASSWORD, password);
    }

    public String getUsername() {
        return this.getField(USERNAME);
    }

    public void setUsername(String username) {
        this.setField(USERNAME, username);
    }

    public String getEmail() {
        return this.getField(EMAIL);
    }

    public void setEmail(String email) {
        this.setField(EMAIL, email);
    }

    public void setLocation(URL location) {
        super.setLocation(location);
        if (this.hasLocation()) {
            String currentLocation = this.getLocation().toExternalForm();
            if (!currentLocation.endsWith("/")) {
                currentLocation = String.valueOf(currentLocation) + "/";
            }
            try {
                URL channelsURL = new URL(String.valueOf(currentLocation) + "channels");
                this.channels.setDefaultLocation(channelsURL);
            }
            catch (MalformedURLException e) {
                this.logError("Error generating channels url: " + e.getMessage());
            }
        }
    }

    public Channel addChannel(String value, ChannelType type) {
        return this.addChannel(value, type, null);
    }

    public Channel addChannel(String value, ChannelType type, ServiceErrors errors) {
        Channel channel = null;
        if (this.hasLocation()) {
            channel = new Channel(value, type);
            channel.setRequestBuilder(this.builder);
            channel.setServiceProvider(this.provider);
            channel.setLogger(this.logger);
            channel.setDefaultLocation(this.channels.getLocation());
            IServiceErrors channelErrors = channel.commit();
            if (errors != null && channelErrors instanceof ServiceErrors) {
                errors.cloneErrors((ServiceErrors)channelErrors);
            }
            if (channel.hasLocation()) {
                channelErrors = channel.update();
                if (errors != null && channelErrors instanceof ServiceErrors) {
                    errors.cloneErrors((ServiceErrors)channelErrors);
                }
                this.channels.update();
                Channel[] channelArray = (Channel[])this.channels.getItems();
                int n = 0;
                int n2 = channelArray.length;
                while (n < n2) {
                    Channel c = channelArray[n];
                    if (c.getId().equals(channel.getId())) {
                        return c;
                    }
                    ++n;
                }
            } else {
                channel = null;
            }
        }
        return channel;
    }

    public void setRequestBuilder(IServiceRequestBuilder builder) {
        super.setRequestBuilder(builder);
        if (this.channels != null) {
            this.channels.setRequestBuilder(this.getRequestBuilder());
        }
    }

    public void setServiceProvider(IServiceProvider provider) {
        super.setServiceProvider(provider);
        if (this.channels != null) {
            this.channels.setServiceProvider(provider);
        }
    }

    public void setLogger(ILogger logger) {
        super.setLogger(logger);
        if (this.channels != null) {
            this.channels.setLogger(this.getLogger());
        }
    }

    public void clear() {
        if (this.channels != null) {
            this.channels.clear();
        }
        this.setField(FIRST_NAME, null);
        this.setField(LAST_NAME, null);
        this.setField(PHONE, null);
        this.setField(IP_ADDRESS, null);
        this.setField(ADDRESS1, null);
        this.setField(ADDRESS2, null);
        this.setField(CITY, null);
        this.setField(STATE, null);
        this.setField(ZIP, null);
        this.setField(COUNTRY, null);
        this.setField(ROLE, null);
        this.setField(COMPANY, null);
        this.setField(ORG_SIZE, null);
        this.setField(ORG_TYPE, null);
        this.setField(SITES_PER_YEAR, null);
        this.setField(AJAX, null);
        this.setField(JAVASCRIPT, null);
        this.setField(PHP, null);
        this.setField(RUBY, null);
        this.setField(JAVA, null);
        this.setField(PYTHON, null);
        this.setField(CAPTCHA_CHALLENGE, null);
        this.setField(CAPTCHA_RESPONSE, null);
    }

    public Node toNode() {
        return null;
    }

    public String getLoggingPrefix() {
        return "User";
    }

    public Channels getChannels() {
        return this.channels;
    }

    protected String getItemString() {
        return USER;
    }
}

