/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.model;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import java.util.ArrayList;
import org.eclipse.core.runtime.ListenerList;

public class BaseModelObject
implements IModifiableObject {
    protected ListenerList listeners = new ListenerList();
    protected boolean suspendEvents = false;
    protected boolean outstandingEvents = false;

    public void suspendEvents() {
        this.suspendEvents = true;
    }

    public void resumeEvents() {
        this.suspendEvents = false;
        if (this.outstandingEvents) {
            this.fireChange();
            this.outstandingEvents = false;
        }
    }

    protected void fireChange() {
        if (!this.suspendEvents) {
            Object[] listens = this.listeners.getListeners();
            int i = 0;
            while (i < listens.length) {
                if (listens[i] instanceof IModelListener) {
                    try {
                        ((IModelListener)listens[i]).modelChanged(this);
                    }
                    catch (Exception e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), "Error notifying model listener", e);
                    }
                    catch (Error e) {
                        IdeLog.logError(AptanaCorePlugin.getDefault(), "Error notifying model listener", e);
                    }
                }
                ++i;
            }
        } else {
            this.outstandingEvents = true;
        }
    }

    public void addListeners(Object[] listeners) {
        if (listeners != null) {
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof IModelListener) {
                    this.addListener((IModelListener)listeners[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isModelChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null) {
            return true;
        }
        if (oldValue != null && newValue == null) {
            return true;
        }
        return oldValue != null && !oldValue.equals(newValue);
    }

    protected boolean isNewValueValid(String oldValue, String newValue) {
        return newValue != null && newValue.length() > 0 && this.isModelChanged(oldValue, newValue);
    }

    public IModelListener[] getListeners() {
        ArrayList<IModelListener> mls = new ArrayList<IModelListener>();
        Object[] listens = this.listeners.getListeners();
        int i = 0;
        while (i < listens.length) {
            if (listens[i] instanceof IModelListener) {
                mls.add((IModelListener)listens[i]);
            }
            ++i;
        }
        return mls.toArray(new IModelListener[0]);
    }

    public void addListener(IModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IModelListener listener) {
        this.listeners.remove((Object)listener);
    }
}

