/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.licensing;

import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.licensing.IClientKeyProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ClientKeyService {
    private static final String POINT_ID = "com.aptana.ide.core";
    private static final String EXT_ID = "licensing";
    private static final String CLASS = "class";
    private static IClientKeyProvider provider = null;
    private static ClientKey clientKey;

    public static final ClientKey getClientKey() {
        if (clientKey != null) {
            return clientKey;
        }
        IClientKeyProvider myProvider = ClientKeyService.getProvider();
        clientKey = myProvider == null ? ClientKey.EMPTY_KEY : myProvider.getClientKey();
        return clientKey != null ? clientKey : ClientKey.EMPTY_KEY;
    }

    public static final ClientKey createClientKey(String key, String email) {
        IClientKeyProvider myProvider = ClientKeyService.getProvider();
        if (myProvider == null) {
            return ClientKey.EMPTY_KEY;
        }
        ClientKey clientKey = myProvider.createClientKey(key, email);
        return clientKey;
    }

    public static final boolean isClientKeyProviderAvail() {
        IClientKeyProvider cp = ClientKeyService.getProvider();
        return cp != null;
    }

    private static final IClientKeyProvider getProvider() {
        IConfigurationElement[] configurationElements;
        if (provider != null) {
            return provider;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID, EXT_ID).getExtensions();
        if (extensions != null && extensions.length < 1) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensions[0].getConfigurationElements();
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            IConfigurationElement element = iConfigurationElementArray[n];
            try {
                provider = (IClientKeyProvider)element.createExecutableExtension(CLASS);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n;
        }
        return provider;
    }
}

