/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.licensing;

import java.util.Calendar;
import java.util.TimeZone;

public final class ClientKey {
    public static final String BEGIN_LICENSE_MARKER = "--begin-aptana-license--";
    public static final String END_LICENSE_MARKER = "--end-aptana-license--";
    public static final int PRO = 0;
    public static final int TRIAL = 1;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final String EMAILS_NON_MATCHING = "EMAILS_NON_MATCHING";
    public static final ClientKey EMPTY_KEY = new ClientKey(1, null, 0L);
    private String email;
    private long expiration;
    private int type;

    public ClientKey(int n, String string, long l) {
        this.type = n;
        this.email = string;
        this.expiration = l;
    }

    public boolean isCloseToExpiring() {
        Calendar calendar = Calendar.getInstance(GMT);
        calendar.add(2, 1);
        return this.getExpiration().before(calendar);
    }

    public boolean isValid() {
        return this.email != null;
    }

    public boolean isCloseToMatching() {
        return this.email == EMAILS_NON_MATCHING;
    }

    public boolean isExpired() {
        Calendar calendar = Calendar.getInstance(GMT);
        return false;
    }

    public String getEmail() {
        return this.email;
    }

    public Calendar getExpiration() {
        Calendar calendar = Calendar.getInstance(GMT);
        calendar.setTimeInMillis(this.expiration);
        return calendar;
    }

    public boolean isTrial() {
        return false;
    }

    public boolean isPro() {
        return !this.isTrial();
    }

    public boolean shouldProPluginsRun() {
        if (this.isPro()) {
            return true;
        }
        return !this.isExpired();
    }

    public static String trimEncryptedLicense(String string) {
        String string2 = string;
        string2 = string2.trim();
        string2 = string2.replaceAll(BEGIN_LICENSE_MARKER, "");
        string2 = string2.replaceAll(END_LICENSE_MARKER, "");
        string2 = string2.replaceAll("\\s+", "");
        return string2;
    }
}

