/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.sync;

import com.aptana.ide.core.io.ConnectionException;
import com.aptana.ide.core.io.IVirtualFile;
import com.aptana.ide.core.io.VirtualFileManagerException;
import java.io.IOException;
import java.io.InputStream;

public class VirtualFileSyncPair {
    private String _relativePath;
    private IVirtualFile _sourceFile;
    private IVirtualFile _destinationFile;
    private int _syncState;
    private int _transferState;

    public VirtualFileSyncPair(IVirtualFile sourceFile, IVirtualFile destinationFile, String relativePath, int syncState) {
        this._sourceFile = sourceFile;
        this._destinationFile = destinationFile;
        this._relativePath = relativePath;
        this._syncState = syncState;
        this._transferState = 0;
    }

    public IVirtualFile getSourceFile() {
        return this._sourceFile;
    }

    public InputStream getSourceInputStream() throws ConnectionException, VirtualFileManagerException, IOException {
        InputStream result = null;
        if (this._sourceFile != null && this._sourceFile.isFile()) {
            result = this._sourceFile.getFileManager().getStream(this._sourceFile);
        }
        return result;
    }

    public void setSourceFile(IVirtualFile sourceFile) {
        this._sourceFile = sourceFile;
    }

    public IVirtualFile getDestinationFile() {
        return this._destinationFile;
    }

    public InputStream getDestinationInputStream() throws ConnectionException, VirtualFileManagerException, IOException {
        InputStream result = null;
        if (this._destinationFile != null && this._destinationFile.isFile()) {
            result = this._destinationFile.getFileManager().getStream(this._destinationFile);
        }
        return result;
    }

    public void setDestinationFile(IVirtualFile destinationFile) {
        this._destinationFile = destinationFile;
    }

    public String getRelativePath() {
        return this._relativePath;
    }

    public int getSyncState() {
        return this._syncState;
    }

    public void setSyncState(int syncState) {
        this._syncState = syncState;
    }

    public int getTransferState() {
        return this._transferState;
    }

    public void setTransferState(int transferState) {
        this._transferState = transferState;
    }

    public boolean isDirectory() {
        if (this.getSyncState() == 8) {
            return false;
        }
        if (this.getSourceFile() != null && this.getSourceFile().isDirectory()) {
            return true;
        }
        return this.getDestinationFile() != null && this.getDestinationFile().isDirectory();
    }
}

