/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io.sync;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.sync.ISerializableSyncItem;
import com.aptana.ide.core.io.sync.Messages;
import com.aptana.ide.core.io.sync.SyncManager;

public class VirtualFileManagerSyncPair
implements ISerializableSyncItem {
    public static final int Upload = 0;
    public static final int Download = 1;
    public static final int Both = 2;
    private String _nickName = "";
    private IVirtualFileManager _sourceFileManager = null;
    private IVirtualFileManager _destinationFileManager = null;
    private long sourceId = -1L;
    private long destId = -1L;
    private int _syncOption = 0;
    private boolean _useCRC = false;
    private boolean _deleteRemoteFiles = false;

    public IVirtualFileManager getSourceFileManager() {
        return this._sourceFileManager;
    }

    public void setSourceFileManager(IVirtualFileManager sourceFileManager) {
        this._sourceFileManager = sourceFileManager;
    }

    public IVirtualFileManager getDestinationFileManager() {
        return this._destinationFileManager;
    }

    public void setDestinationFileManager(IVirtualFileManager destinationFileManager) {
        this._destinationFileManager = destinationFileManager;
    }

    public String getNickName() {
        return this._nickName;
    }

    public void setNickName(String nickName) {
        this._nickName = nickName;
    }

    public int getSyncState() {
        return this._syncOption;
    }

    public void setSyncState(int syncOption) {
        this._syncOption = syncOption;
    }

    public boolean isDeleteRemoteFiles() {
        return this._deleteRemoteFiles;
    }

    public void setDeleteRemoteFiles(boolean remoteFiles) {
        this._deleteRemoteFiles = remoteFiles;
    }

    public boolean isUseCRC() {
        return this._useCRC;
    }

    public boolean isValid() {
        return this.getDestinationFileManager() != null && this.getDestinationFileManager().getBasePath() != null && this.getSourceFileManager() != null && this.getSourceFileManager().getBasePath() != null && this.getSourceFileManager().isValid() && this.getDestinationFileManager().isValid();
    }

    public void setUseCRC(boolean usecrc) {
        this._useCRC = usecrc;
    }

    public String toSerializableString() {
        try {
            boolean shouldSerialize = true;
            if (this._sourceFileManager != null && "".equals(this._sourceFileManager.toSerializableString())) {
                shouldSerialize = false;
            } else if (this._destinationFileManager != null && "".equals(this._destinationFileManager.toSerializableString())) {
                shouldSerialize = false;
            }
            String result = "";
            if (shouldSerialize) {
                result = String.valueOf(result) + this._nickName + "%%%%";
                long sourceFileId = this._sourceFileManager == null ? this.sourceId : this._sourceFileManager.getId();
                long destinationFileId = this._destinationFileManager == null ? this.destId : this._destinationFileManager.getId();
                result = String.valueOf(result) + sourceFileId + "%%%%";
                result = String.valueOf(result) + destinationFileId + "%%%%";
                result = String.valueOf(result) + this._syncOption + "%%%%";
                result = String.valueOf(result) + this._useCRC + "%%%%";
                result = String.valueOf(result) + this._deleteRemoteFiles + "%%%%";
            }
            return result;
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.VirtualFileManagerSyncPair_UnableToSerializeSyncPair, e);
            return null;
        }
    }

    public void fromSerializableString(String s) {
        try {
            String[] args = s.split("%%%%");
            if (args.length < 3) {
                return;
            }
            this.setNickName(args[0]);
            String sourceId = args[1];
            String destinationId = args[2];
            this.sourceId = Long.parseLong(sourceId);
            this.destId = Long.parseLong(destinationId);
            this._sourceFileManager = this.sourceId == -1L ? null : SyncManager.getSyncManager().getVirtualFileManagerById(this.sourceId);
            this._destinationFileManager = this.destId == -1L ? null : SyncManager.getSyncManager().getVirtualFileManagerById(this.destId);
            this.setSyncState(Integer.parseInt(args[3]));
            this.setUseCRC(args[4] == "true");
            this.setDeleteRemoteFiles(args[5] == "true");
        }
        catch (Exception e) {
            IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.VirtualFileManagerSyncPair_UnableToLoadSyncConfiguration, e);
        }
    }

    public String getType() {
        return "com.aptana.ide.core.io.sync.VirtualFileManagerSyncItem";
    }
}

