/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.io.IVirtualFileManagerDialog;
import com.aptana.ide.core.io.Messages;
import com.aptana.ide.core.io.sync.SyncManager;
import com.aptana.ide.core.io.sync.VirtualFileManagerSyncPair;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public abstract class ProtocolManager
implements Comparable {
    private static ProtocolManager[] protocolManagers;
    private String _fileManagerName = "";
    private String _displayName = "";
    private boolean _hidden = false;
    private boolean _remote = false;

    public boolean hasCustomContent() {
        return false;
    }

    public Object[] getContent() {
        return null;
    }

    public boolean canAddFileManagers() {
        return true;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getFileManagerName() {
        return this._fileManagerName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setFileManagerName(String fileManagerName) {
        this._fileManagerName = fileManagerName;
    }

    public abstract IVirtualFileManager[] getFileManagers();

    public abstract String getManagedType();

    public IVirtualFileManager getFileManager(String absolutePath) {
        IVirtualFileManager[] fms = this.getFileManagers();
        int i = 0;
        while (i < fms.length) {
            IVirtualFileManager manager = fms[i];
            if (manager.getBasePath() != null && absolutePath.equals(manager.getBaseFile().getAbsolutePath())) {
                return manager;
            }
            ++i;
        }
        return null;
    }

    public Image getImage() {
        return null;
    }

    public void addFileManager(IVirtualFileManager fileManager) {
        if (fileManager == null) {
            throw new IllegalArgumentException(Messages.ProtocolManager_FileManagerNullError);
        }
        SyncManager.getSyncManager().addItem(fileManager);
    }

    public void removeFileManager(IVirtualFileManager fileManager) {
        if (fileManager != null) {
            VirtualFileManagerSyncPair[] pairs = SyncManager.getSyncPairs(fileManager);
            int i = 0;
            while (i < pairs.length) {
                VirtualFileManagerSyncPair pair = pairs[i];
                if (pair.getDestinationFileManager() != null && pair.getDestinationFileManager().equals(fileManager)) {
                    pair.setDestinationFileManager(null);
                }
                if (pair.getSourceFileManager() != null && pair.getSourceFileManager().equals(fileManager)) {
                    pair.setSourceFileManager(null);
                }
                ++i;
            }
            SyncManager.getSyncManager().removeItem(fileManager);
        }
    }

    public int compareTo(Object o) {
        if (o instanceof ProtocolManager) {
            return this.getDisplayName().compareToIgnoreCase(((ProtocolManager)o).getDisplayName());
        }
        return 0;
    }

    public abstract IVirtualFileManager createFileManager();

    public IVirtualFileManager createFileManager(boolean addManager) {
        return this.createFileManager();
    }

    public abstract IVirtualFileManagerDialog createPropertyDialog(Shell var1, int var2);

    public abstract ProtocolManager getStaticInstance();

    public static ProtocolManager getProtocolManagerByName(String name) {
        ProtocolManager result = null;
        if (protocolManagers == null) {
            ProtocolManager.getPrototcolManagers();
        }
        int i = 0;
        while (i < protocolManagers.length) {
            ProtocolManager manager = protocolManagers[i];
            if (manager.getFileManagerName().equals(name)) {
                result = manager;
                break;
            }
            ++i;
        }
        return result;
    }

    public static ProtocolManager getProtocolManagerByType(String type) {
        if (protocolManagers == null) {
            ProtocolManager.getPrototcolManagers();
        }
        int i = 0;
        while (i < protocolManagers.length) {
            ProtocolManager manager = protocolManagers[i];
            if (manager.getManagedType().equals(type)) {
                return manager;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolManager[] getPrototcolManagers() {
        if (protocolManagers != null) {
            return protocolManagers;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("com.aptana.ide.core", "protocols").getExtensions();
        Hashtable<String, Integer> priorityTable = new Hashtable<String, Integer>();
        Hashtable<String, ProtocolManager> found = new Hashtable<String, ProtocolManager>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                try {
                    IConfigurationElement element = configElements[j];
                    ProtocolManager pm = (ProtocolManager)configElements[j].createExecutableExtension("class");
                    if (pm != null) {
                        pm = pm.getStaticInstance();
                        String displayName = element.getAttribute("displayName");
                        pm.setDisplayName(displayName);
                        pm.setFileManagerName(element.getAttribute("fileManagerName"));
                        String hidden = element.getAttribute("hidden");
                        String remote = element.getAttribute("remote");
                        String pri = element.getAttribute("priority");
                        Integer priority = 0;
                        if (pri != null && !"".equals(pri)) {
                            priority = Integer.parseInt(pri);
                        }
                        if (remote != null && "true".equalsIgnoreCase(remote)) {
                            pm.setRemote(true);
                        }
                        if (hidden != null && "true".equalsIgnoreCase(hidden)) {
                            pm.setHidden(true);
                        }
                        Integer oldPriority = -1;
                        if (priorityTable.containsKey(displayName)) {
                            oldPriority = (Integer)priorityTable.get(displayName);
                        }
                        if (oldPriority < priority) {
                            priorityTable.put(displayName, priority);
                            found.put(displayName, pm);
                        }
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.ProtocolManager_UnableToLoadProtocolManagerError, ex);
                }
                ++j;
            }
            ++i;
        }
        protocolManagers = found.values().toArray(new ProtocolManager[0]);
        return protocolManagers;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isRemote() {
        return this._remote;
    }

    public void setRemote(boolean remote) {
        this._remote = remote;
    }
}

