/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.db;

import com.aptana.ide.core.db.AptanaDB;
import com.aptana.ide.core.db.EventInfo;
import com.aptana.ide.core.db.IResultSetHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;

public final class EventLogger {
    static EventLogger INSTANCE;
    private static final String TABLE_NAME = "eventLog";
    private static final String DATE_TIME = "dateTime";
    private static final String EVENT_TYPE = "eventType";
    private static final String MESSAGE = "message";
    private static final String GET_EVENTS;

    static {
        GET_EVENTS = MessageFormat.format("SELECT {0},{1},{2} FROM {3} ORDER BY {0}", DATE_TIME, EVENT_TYPE, MESSAGE, TABLE_NAME);
    }

    private EventLogger() {
    }

    public static EventLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventLogger();
            AptanaDB db = AptanaDB.getInstance();
            if (!INSTANCE.tableExists()) {
                String query = MessageFormat.format("CREATE TABLE {0}({1} bigint,{2} varchar(255),{3} varchar(255))", TABLE_NAME, DATE_TIME, EVENT_TYPE, MESSAGE);
                db.execute(query);
            }
        }
        return INSTANCE;
    }

    public void logEvent(String eventType) {
        this.logEvent(eventType, null);
    }

    public void logEvent(String eventType, String message) {
        String dateTime = Long.toString(System.currentTimeMillis());
        String query = MessageFormat.format("INSERT INTO {0}({1},{2},{3}) VALUES({4},''{5}'',''{6}'')", TABLE_NAME, DATE_TIME, EVENT_TYPE, MESSAGE, dateTime, eventType != null && eventType.length() > 0 ? eventType : "<unknown>", message != null ? message : "");
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvents() {
        String query = "DELETE FROM eventLog";
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvents(String eventType) {
        String query = MessageFormat.format("DELETE FROM {0} WHERE {1}=''{2}''", TABLE_NAME, EVENT_TYPE, eventType);
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvents(long beforeTime) {
        String query = MessageFormat.format("DELETE FROM {0} WHERE {1} < {2}", TABLE_NAME, DATE_TIME, Long.toString(beforeTime));
        AptanaDB.getInstance().execute(query);
    }

    public void clearEvents(String eventType, long beforeTime) {
        String query = MessageFormat.format("DELETE FROM {0} WHERE {1}=''{2}'' AND {3} < {4}", TABLE_NAME, EVENT_TYPE, eventType, DATE_TIME, Long.toString(beforeTime));
        AptanaDB.getInstance().execute(query);
    }

    public EventInfo[] getEvents() {
        final ArrayList events = new ArrayList();
        AptanaDB.getInstance().execute(GET_EVENTS, new IResultSetHandler(){

            public void processResultSet(ResultSet resultSet) throws SQLException {
                long dateTime = resultSet.getLong(1);
                String eventType = resultSet.getString(2);
                String message = resultSet.getString(3);
                events.add(new EventInfo(dateTime, eventType, message));
            }
        });
        return events.toArray(new EventInfo[events.size()]);
    }

    public EventInfo[] getEvents(String eventType) {
        String query = MessageFormat.format("SELECT {0},{1},{2} FROM {3} WHERE {1}=''{4}'' ORDER BY {0}", DATE_TIME, EVENT_TYPE, MESSAGE, TABLE_NAME, eventType);
        final ArrayList events = new ArrayList();
        AptanaDB.getInstance().execute(query, new IResultSetHandler(){

            public void processResultSet(ResultSet resultSet) throws SQLException {
                long dateTime = resultSet.getLong(1);
                String eventType = resultSet.getString(2);
                String message = resultSet.getString(3);
                events.add(new EventInfo(dateTime, eventType, message));
            }
        });
        return events.toArray(new EventInfo[events.size()]);
    }

    private boolean tableExists() {
        boolean result;
        block24: {
            Statement statement;
            Connection connection;
            block23: {
                connection = null;
                statement = null;
                result = true;
                try {
                    try {
                        connection = AptanaDB.getInstance().getConnection();
                        statement = connection.createStatement();
                        statement.execute("SELECT COUNT(*) FROM eventLog");
                    }
                    catch (SQLException sqle) {
                        String errorStateCode = sqle.getSQLState();
                        if (!errorStateCode.equals("42X05")) break block23;
                        result = false;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
                break block24;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return result;
    }
}

