/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.Messages;
import com.aptana.ide.internal.core.CoreNatives;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;

public final class PlatformUtils {
    public static final String DESKTOP_DIRECTORY = "%DesktopDirectory%";

    private PlatformUtils() {
    }

    public static String[] getRunningProcesses() {
        block20: {
            if ("win32".equals(Platform.getOS())) {
                try {
                    return CoreNatives.GetProcessList();
                }
                catch (UnsatisfiedLinkError e) {
                    IdeLog.logError(AptanaCorePlugin.getDefault(), Messages.PlatformUtils_CoreLibraryNotFound, e);
                    break block20;
                }
            }
            if ("linux".equals(Platform.getOS())) {
                ArrayList<String> list = new ArrayList<String>();
                Process process = null;
                try {
                    try {
                        String line;
                        process = Runtime.getRuntime().exec("/bin/ps --no-headers xo args");
                        InputStream in = process.getInputStream();
                        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = reader.readLine()) != null) {
                            int index = line.indexOf(32);
                            if (index != -1) {
                                line = line.substring(0, index);
                            }
                            list.add(line);
                        }
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
                return list.toArray(new String[list.size()]);
            }
            if ("macosx".equals(Platform.getOS())) {
                ArrayList<String> list = new ArrayList<String>();
                Process process = null;
                try {
                    try {
                        String line;
                        process = Runtime.getRuntime().exec("/usr/bin/perl");
                        InputStream in = process.getInputStream();
                        OutputStream out = process.getOutputStream();
                        String command = "use Mac::Processes; while ( ($psn, $psi) = each(%Process) ) { print $psi->processAppSpec.\"\\n\"; }";
                        out.write(command.getBytes("ISO-8859-1"));
                        out.close();
                        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in, "ISO-8859-1"));
                        while ((line = reader.readLine()) != null) {
                            list.add(line);
                        }
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    if (process != null) {
                        process.destroy();
                    }
                }
                return list.toArray(new String[list.size()]);
            }
        }
        return null;
    }

    public static String expandEnvironmentStrings(String path) {
        String home;
        if ("win32".equals(Platform.getOS())) {
            String desktopDirectory;
            String expanded = CoreNatives.ExpandEnvironmentStrings(path);
            if (expanded != null) {
                path = expanded;
            }
            if (path.startsWith(DESKTOP_DIRECTORY) && (desktopDirectory = CoreNatives.GetSpecialFolderPath(16)) != null) {
                path = String.valueOf(desktopDirectory) + path.substring(DESKTOP_DIRECTORY.length());
            }
        }
        if (path.startsWith("~") && (home = System.getProperty("user.home")) != null) {
            return String.valueOf(home) + path.substring(1);
        }
        return path;
    }

    public static String queryRegestryStringValue(String keyName, String valueName) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegOpenKey(hRootKey, keyName, hKey)) {
                String[] result = new String[1];
                CoreNatives.RegQueryValue(hKey[0], valueName, result);
                CoreNatives.RegCloseKey(hKey[0]);
                return result[0];
            }
        }
        return null;
    }

    public static boolean setRegestryStringValue(String keyName, String valueName, String value) {
        if ("win32".equals(Platform.getOS())) {
            long hRootKey;
            if (keyName.startsWith("HKCR\\") || keyName.startsWith("HKEY_CLASSES_ROOT\\")) {
                hRootKey = Integer.MIN_VALUE;
            } else if (keyName.startsWith("HKLM\\") || keyName.startsWith("HKEY_LOCAL_MACHINE\\")) {
                hRootKey = -2147483646L;
            } else if (keyName.startsWith("HKCU\\") || keyName.startsWith("HKEY_CURRENT_USER\\")) {
                hRootKey = -2147483647L;
            } else {
                throw new IllegalArgumentException("Invalid regestry key name");
            }
            keyName = keyName.substring(keyName.indexOf(92) + 1);
            long[] hKey = new long[1];
            if (CoreNatives.RegCreateKey(hRootKey, keyName, hKey)) {
                boolean result = CoreNatives.RegSetValue(hKey[0], valueName, value);
                CoreNatives.RegCloseKey(hKey[0]);
                return result;
            }
        }
        return false;
    }

    public static boolean isUserAdmin() {
        if ("win32".equals(Platform.getOS())) {
            return CoreNatives.IsUserAnAdmin();
        }
        return false;
    }

    public static boolean runAsAdmin(String program, String[] arguments) {
        if ("win32".equals(Platform.getOS())) {
            StringBuffer sb = null;
            if (arguments != null && arguments.length > 0) {
                sb = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    String arg = arguments[i];
                    if (arg.indexOf(32) != -1) {
                        sb.append('\"').append(arg).append('\"');
                    } else {
                        sb.append(arg);
                    }
                    sb.append(' ');
                    ++i;
                }
            }
            return CoreNatives.ShellExecuteEx(program, sb != null ? sb.toString() : null, "runas", null, 1);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String getApplicationInfo(String applicationPath, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static File getApplicationExecutable(String applicationPath) {
        File file = new File(applicationPath);
        if ("macosx".equals(Platform.getOS())) {
            if (!file.isDirectory()) {
                return file;
            }
            String executable = PlatformUtils.getApplicationInfo(applicationPath, "CFBundleExecutable");
            if (executable != null) {
                File file2 = new File(file, "Contents/MacOSX/" + executable);
                if (file2.exists()) {
                    return file2;
                }
                file2 = new File(file, "Contents/MacOS/" + executable);
                if (file2.exists()) {
                    return file2;
                }
            }
        }
        return file;
    }
}

